/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.handlers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.animations.AnimationHandler;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.utils.ItemBuilder;
import me.davidml16.acubelets.utils.SkullCreator;
import me.davidml16.acubelets.utils.TimeAPI.TimeAPI;
import me.davidml16.acubelets.utils.Utils;
import me.davidml16.acubelets.utils.XSeries.XItemStack;
import me.davidml16.acubelets.utils.XSeries.XMaterial;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class CubeletTypesHandler {
    private HashMap<String, CubeletType> types;
    private HashMap<String, File> typesFiles;
    private HashMap<String, YamlConfiguration> typesConfigs;
    private Main main;

    public CubeletTypesHandler(Main main) {
        this.main = main;
        this.types = new HashMap();
        this.typesFiles = new HashMap();
        this.typesConfigs = new HashMap();
    }

    public HashMap<String, CubeletType> getTypes() {
        return this.types;
    }

    public HashMap<String, File> getTypesFiles() {
        return this.typesFiles;
    }

    public HashMap<String, YamlConfiguration> getTypesConfigs() {
        return this.typesConfigs;
    }

    public CubeletType getTypeBydId(String string) {
        for (CubeletType cubeletType : this.types.values()) {
            if (!cubeletType.getId().equalsIgnoreCase(string)) continue;
            return cubeletType;
        }
        return null;
    }

    public boolean createType(String string) {
        File file = new File(this.main.getDataFolder(), "types/" + string + ".yml");
        if (!file.exists()) {
            try {
                file.createNewFile();
                this.typesFiles.put(string, file);
                this.typesConfigs.put(string, YamlConfiguration.loadConfiguration((File)file));
                return true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return false;
    }

    public boolean removeType(String string) {
        if (this.typesFiles.containsKey(string) && this.typesConfigs.containsKey(string)) {
            this.typesFiles.get(string).delete();
            this.typesFiles.remove(string);
            this.typesConfigs.remove(string);
            return true;
        }
        return false;
    }

    public void saveConfig(String string) {
        try {
            File file = this.typesFiles.get(string);
            if (file.exists()) {
                this.typesConfigs.get(string).save(file);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public FileConfiguration getConfig(String string) {
        return (FileConfiguration)this.typesConfigs.get(string);
    }

    public void loadTypes() {
        File[] fileArray;
        this.typesConfigs.clear();
        this.typesFiles.clear();
        this.types.clear();
        File file = new File(this.main.getDataFolder(), "types");
        if (!file.exists()) {
            file.mkdir();
        }
        for (File file2 : fileArray = new File(this.main.getDataFolder(), "types").listFiles()) {
            Object object;
            Object object2;
            String string = file2.getName().toLowerCase().replace(".yml", "");
            if (string.equalsIgnoreCase("random")) continue;
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file2);
            this.typesFiles.put(string, file2);
            this.typesConfigs.put(string, yamlConfiguration);
            if (Character.isDigit(string.charAt(0)) || !this.validTypeData((FileConfiguration)yamlConfiguration)) continue;
            if (!yamlConfiguration.contains("type.animation")) {
                yamlConfiguration.set("type.animation", (Object)"animation1");
            }
            if (!yamlConfiguration.contains("type.expiration")) {
                yamlConfiguration.set("type.expiration", (Object)"2w");
            }
            if (!yamlConfiguration.contains("type.description")) {
                object2 = Arrays.asList("&7This is the most common type of ", "&7Cubelet. Initial scans indicate ", "&7that the contents of this cubelet ", "&7will be probably basic. ");
                yamlConfiguration.set("type.description", object2);
            }
            if (!yamlConfiguration.contains("type.lore.opening.available")) {
                object2 = Arrays.asList("&5Received: &a%received% ago", "&5Expires: &aIn %expires%", "", "%description%", "", "&6Click to open.");
                yamlConfiguration.set("type.lore.opening.available", object2);
            }
            if (!yamlConfiguration.contains("type.lore.opening.expired")) {
                object2 = Arrays.asList("&5Received: &a%received% ago", "&5Expires: &cExpired", "", "%description%", "");
                yamlConfiguration.set("type.lore.opening.expired", object2);
            }
            if (!yamlConfiguration.contains("type.icon")) {
                yamlConfiguration.set("type.icon.texture", (Object)"base64:eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYWYyMmI2YTNhMGYyNGJkZWVhYjJhNmFjZDliMWY1MmJiOTU5NGQ1ZjZiMWUyYzA1ZGRkYjIxOTQxMGM4In19fQ==");
            }
            if (!yamlConfiguration.contains("type.key")) {
                object2 = new ItemBuilder(XMaterial.TRIPWIRE_HOOK.parseMaterial(), 1).addGlow().setName(Utils.translate(yamlConfiguration.getString("type.name") + "'s key")).setLore(Arrays.asList(Utils.translate("&8&oGo to a Cubelets Machine to"), Utils.translate("&8&oopen this key."), "", Utils.translate("&a&lLeft-Click: &6Preview rewards"), Utils.translate("&a&lRight-Click: &6Open cubelet key"))).toItemStack();
                if (!this.main.isSerializeBase64()) {
                    XItemStack.serializeItem((ItemStack)object2, (FileConfiguration)yamlConfiguration, "type.key");
                } else {
                    yamlConfiguration.set("type.key", (Object)XItemStack.itemStackToBase64((ItemStack)object2));
                }
            }
            if (!yamlConfiguration.contains("type.rarities")) {
                yamlConfiguration.set("type.rarities", new ArrayList());
            }
            if (!yamlConfiguration.contains("type.rewards")) {
                yamlConfiguration.set("type.rewards", new ArrayList());
            }
            if (!yamlConfiguration.getString("type.animation").contains("animation")) {
                yamlConfiguration.set("type.animation", (Object)AnimationHandler.DEFAULT_ANIMATION);
            }
            this.saveConfig(string);
            object2 = yamlConfiguration.getString("type.name");
            CubeletType cubeletType = new CubeletType(this.main, string, (String)object2);
            this.types.put(string, cubeletType);
            cubeletType.setAnimation(yamlConfiguration.getString("type.animation").toLowerCase());
            if (!(yamlConfiguration.get("type.icon.texture") instanceof MemorySection)) {
                object = ((String)yamlConfiguration.get("type.icon.texture")).split(":");
                switch (object[0].toLowerCase()) {
                    case "base64": {
                        cubeletType.setIcon(SkullCreator.itemFromBase64(object[1]));
                        break;
                    }
                    case "uuid": {
                        cubeletType.setIcon(SkullCreator.itemFromUuid(UUID.fromString(object[1])));
                        break;
                    }
                    case "name": {
                        cubeletType.setIcon(SkullCreator.itemFromName(object[1]));
                    }
                }
            } else {
                try {
                    cubeletType.setIcon(new ItemBuilder(XItemStack.itemStackFromBase64(yamlConfiguration.getString("type.icon.texture"))).setLore("").toItemStack());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            object = new ArrayList();
            for (String string2 : yamlConfiguration.getStringList("type.lore.opening.available")) {
                if (string2.contains("%description%")) {
                    object.addAll(yamlConfiguration.getStringList("type.description"));
                    continue;
                }
                object.add(string2);
            }
            cubeletType.setLoreAvailable((List<String>)object);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string3 : yamlConfiguration.getStringList("type.lore.opening.expired")) {
                if (string3.contains("%description%")) {
                    arrayList.addAll(yamlConfiguration.getStringList("type.description"));
                    continue;
                }
                arrayList.add(string3);
            }
            cubeletType.setLoreExpired(arrayList);
            cubeletType.setDescription(yamlConfiguration.getStringList("type.description"));
            long l = Objects.requireNonNull(yamlConfiguration.getString("type.expiration")).equalsIgnoreCase("") ? 0L : new TimeAPI(yamlConfiguration.getString("type.expiration")).getMilliseconds();
            cubeletType.setExpireTime(l);
            ItemStack itemStack = null;
            if (yamlConfiguration.get("type.key") instanceof MemorySection) {
                itemStack = XItemStack.deserializeItem((FileConfiguration)yamlConfiguration, "type.key");
            } else {
                try {
                    itemStack = XItemStack.itemStackFromBase64(yamlConfiguration.getString("type.key"));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            cubeletType.setKey(itemStack);
        }
    }

    private boolean validTypeData(FileConfiguration fileConfiguration) {
        return fileConfiguration.contains("type.name");
    }

    public boolean typeExist(String string) {
        return this.typesFiles.containsKey(string);
    }

    public void printLog() {
        Main.log.sendMessage(Utils.translate(""));
        Main.log.sendMessage(Utils.translate("  &eLoading cubelets:"));
        int n = this.longestID();
        for (CubeletType cubeletType : this.types.values()) {
            String string = "    &a'" + cubeletType.getId() + "' " + this.getStringSpaces(cubeletType.getId(), n) + "&7\u25ba ";
            int n2 = cubeletType.getRarities().size();
            string = string + (n2 > 0 ? "&a" : "&c") + n2 + " rarities&7, ";
            int n3 = cubeletType.getAllRewards().size();
            string = string + (n3 > 0 ? "&a" : "&c") + n3 + " rewards";
            Main.log.sendMessage(Utils.translate(string));
        }
        if (this.types.size() == 0) {
            Main.log.sendMessage(Utils.translate("    &cNo cubelets has been loaded!"));
        }
        Main.log.sendMessage(Utils.translate(""));
    }

    public int longestID() {
        int n = 0;
        for (String string : this.types.keySet()) {
            if (string.length() <= n) continue;
            n = string.length();
        }
        return n;
    }

    public String getStringSpaces(String string, int n) {
        String string2 = "";
        if (string.length() >= n) {
            return string2;
        }
        string2 = string2 + StringUtils.repeat((String)" ", (int)(n - string.length()));
        return string2;
    }
}

