/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.handlers;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.utils.ConfigUpdater;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class LanguageHandler {
    private String language = null;
    private File file;
    private FileConfiguration config;
    private HashMap<String, String> messages;
    private HashMap<String, List<String>> messageList;
    private Main main;

    public LanguageHandler(Main main, String string) {
        this.main = main;
        new File(main.getDataFolder().toString() + "/language").mkdirs();
        this.loadLanguage("en");
        this.loadLanguage("es");
        this.loadLanguage("de");
        this.language = this.checkLanguage(string);
        this.messages = new HashMap();
        this.messageList = new HashMap();
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public String getPrefix() {
        return Utils.translate(this.messages.get("Prefix"));
    }

    public String getMessage(String string) {
        return Utils.translate(this.messages.get(string).replaceAll("%prefix%", this.messages.get("Prefix")));
    }

    public List<String> getMessageList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.messageList.get(string)) {
            arrayList.add(Utils.translate(string2).replaceAll("%prefix%", this.messages.get("Prefix")));
        }
        return arrayList;
    }

    public String checkLanguage(String string) {
        File file = new File("plugins/ACubelets/language/messages_" + string + ".yml");
        if (file.exists()) {
            return string;
        }
        return "en";
    }

    public void pushMessages() {
        Main.log.sendMessage(Utils.translate(""));
        Main.log.sendMessage(Utils.translate("  &eLoading language:"));
        this.file = new File("plugins/ACubelets/language/messages_" + this.language + ".yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        for (String string : this.config.getKeys(true)) {
            if (this.config.get(string) instanceof MemorySection) continue;
            if (this.config.get(string) instanceof ArrayList) {
                this.messageList.put(string, this.config.getStringList(string));
                continue;
            }
            this.messages.put(string, this.config.getString(string));
        }
        Main.log.sendMessage(Utils.translate("    &a'" + this.language + "' loaded!"));
    }

    public void loadLanguage(String string) {
        File file = new File(this.main.getDataFolder() + "/language/messages_" + string + ".yml");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        yamlConfiguration.options().header("\nThis is the messsages file.\nYou can change any messages that are in this file\n\nIf you want to reset a message back to the default,\ndelete the entire line the message is on and restart the server.\n\t");
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        InputStreamReader inputStreamReader = new InputStreamReader(this.main.getResource("language/messages_" + string + ".yml"));
        YamlConfiguration yamlConfiguration2 = YamlConfiguration.loadConfiguration((Reader)inputStreamReader);
        for (String string2 : yamlConfiguration2.getKeys(true)) {
            if (yamlConfiguration2.get(string2) instanceof MemorySection) continue;
            linkedHashMap.put(string2, yamlConfiguration2.get(string2));
        }
        for (String string2 : linkedHashMap.keySet()) {
            if (yamlConfiguration.isSet(string2)) continue;
            yamlConfiguration.set(string2, linkedHashMap.get(string2));
        }
        for (String string2 : yamlConfiguration.getKeys(true)) {
            if (yamlConfiguration.get(string2) instanceof MemorySection || yamlConfiguration2.isSet(string2)) continue;
            yamlConfiguration.set(string2, null);
        }
        int n = Math.max(yamlConfiguration.getStringList("Holograms.Reward.New.Me").size(), yamlConfiguration.getStringList("Holograms.Reward.New.Other").size());
        int n2 = yamlConfiguration.getStringList("Holograms.Reward.Duplicate").size();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n2 - n; ++i) {
            arrayList.add("");
        }
        arrayList.addAll(yamlConfiguration.getStringList("Holograms.Reward.New.Me"));
        yamlConfiguration.set("Holograms.Reward.New.Me", arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < n2 - n; ++i) {
            arrayList2.add("");
        }
        arrayList2.addAll(yamlConfiguration.getStringList("Holograms.Reward.New.Other"));
        yamlConfiguration.set("Holograms.Reward.New.Other", arrayList2);
        try {
            yamlConfiguration.save(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            ConfigUpdater.update((Plugin)this.main, "language/messages_" + string + ".yml", new File(this.main.getDataFolder() + "/language/messages_" + string + ".yml"), Collections.emptyList());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

