/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.menus.admin.crafting;

import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.conversation.crafting.CraftIngredientCubeletConversation;
import me.davidml16.acubelets.conversation.crafting.CraftIngredientMoneyConversation;
import me.davidml16.acubelets.conversation.crafting.CraftIngredientPointsConversation;
import me.davidml16.acubelets.conversation.crafting.EditCraftIngredientCubeletConversation;
import me.davidml16.acubelets.conversation.crafting.EditCraftIngredientMoneyConversation;
import me.davidml16.acubelets.conversation.crafting.EditCraftIngredientPointsConversation;
import me.davidml16.acubelets.enums.CraftType;
import me.davidml16.acubelets.menus.admin.crafting.EditCraftingCraftsMenu;
import me.davidml16.acubelets.objects.CraftIngredient;
import me.davidml16.acubelets.objects.CraftParent;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.utils.ItemBuilder;
import me.davidml16.acubelets.utils.Utils;
import me.davidml16.acubelets.utils.XSeries.XMaterial;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class EditCraftingIngredientsMenu
extends Menu {
    public EditCraftingIngredientsMenu(Main main, Player player) {
        super(main, player);
    }

    @Override
    public void OnPageOpened(int n) {
        int n2;
        CraftParent craftParent = (CraftParent)this.getAttribute(Menu.AttrType.CRAFT_PARENT_ATTR);
        List<CraftIngredient> list = craftParent.getIngrediens();
        if (n > 0 && list.size() < n * 21 + 1) {
            this.openPage(this.getPage() - 1);
            return;
        }
        Inventory inventory = this.createInventory(36, "Crafting editor | Ingredients");
        ItemStack itemStack = new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack();
        ItemStack itemStack2 = new ItemBuilder(XMaterial.SUNFLOWER.parseItem()).setName(Utils.translate("&aCreate new ingredient")).setLore("", Utils.translate("&eLeft-Click \u00bb &aCubelet ingredient "), Utils.translate("&eMiddle-Click \u00bb &aLoot Points ingredient "), Utils.translate("&eRight-Click \u00bb &aMoney ingredient ")).toItemStack();
        ItemStack itemStack3 = new ItemBuilder(XMaterial.ARROW.parseItem()).setName(Utils.translate("&aBack")).toItemStack();
        this.fillBorders(itemStack);
        inventory.setItem(30, itemStack2);
        inventory.setItem(32, itemStack3);
        for (n2 = 10; n2 <= 16; ++n2) {
            inventory.setItem(n2, null);
        }
        for (n2 = 19; n2 <= 25; ++n2) {
            inventory.setItem(n2, null);
        }
        if (n > 0) {
            inventory.setItem(27, new ItemBuilder(XMaterial.ENDER_PEARL.parseItem()).setName(Utils.translate("&aPrevious page")).toItemStack());
        } else {
            inventory.setItem(27, new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack());
        }
        if (list.size() > (n + 1) * 14) {
            inventory.setItem(35, new ItemBuilder(XMaterial.ENDER_PEARL.parseItem()).setName(Utils.translate("&aNext page")).toItemStack());
        } else {
            inventory.setItem(35, new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack());
        }
        if (list.size() > 14) {
            list = list.subList(n * 14, n * 14 + 14 > list.size() ? list.size() : n * 14 + 14);
        }
        if (list.size() > 0) {
            for (CraftIngredient craftIngredient : list) {
                List<String> list2 = craftIngredient.getCraftType() == CraftType.CUBELET ? Arrays.asList("", Utils.translate(" &7Parent: &6" + craftIngredient.getParentType() + " "), Utils.translate(" &7Type: &6" + craftIngredient.getCraftType().toString() + " "), Utils.translate(" &7Name: &6" + craftIngredient.getName() + " "), Utils.translate(" &7Amount: &6" + craftIngredient.getAmount() + " "), "", Utils.translate("&eLeft-Click \u00bb &aRemove ingredient "), Utils.translate("&eRight-Click \u00bb &aEdit ingredient ")) : Arrays.asList("", Utils.translate(" &7Parent: &6" + craftIngredient.getParentType() + " "), Utils.translate(" &7Type: &6" + craftIngredient.getCraftType().toString() + " "), Utils.translate(" &7Amount: &6" + craftIngredient.getAmount() + " "), "", Utils.translate("&eLeft-Click \u00bb &aEdit ingredient "), Utils.translate("&eRight-Click \u00bb &aRemove ingredient "));
                ItemStack itemStack4 = new ItemBuilder(this.getIconByIngredient(craftIngredient)).setName(Utils.translate("&a" + craftIngredient.getName() + " x" + craftIngredient.getAmount())).setLore(list2).toItemStack();
                itemStack4 = NBTEditor.set(itemStack4, craftIngredient.getUuid().toString(), "ingredientUUID");
                inventory.addItem(new ItemStack[]{itemStack4});
            }
        } else {
            int n3;
            ItemStack itemStack5 = new ItemBuilder(XMaterial.RED_STAINED_GLASS_PANE.parseItem()).setName(Utils.translate("&cAny ingredients created")).setLore("", Utils.translate(" &7You dont have any "), Utils.translate(" &7ingredients created. "), "").toItemStack();
            for (n3 = 10; n3 <= 16; ++n3) {
                inventory.setItem(n3, itemStack5);
            }
            for (n3 = 19; n3 <= 25; ++n3) {
                inventory.setItem(n3, itemStack5);
            }
        }
        this.openInventory();
    }

    @Override
    public void OnMenuClick(InventoryClickEvent inventoryClickEvent) {
        inventoryClickEvent.setCancelled(true);
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        Player player = this.getOwner();
        int n = inventoryClickEvent.getRawSlot();
        CraftParent craftParent = (CraftParent)this.getAttribute(Menu.AttrType.CRAFT_PARENT_ATTR);
        if (n == 27 && inventoryClickEvent.getCurrentItem().getType() == XMaterial.ENDER_PEARL.parseMaterial()) {
            this.previousPage();
            this.playSound(Menu.SoundType.CLICK);
        } else if (n == 35 && inventoryClickEvent.getCurrentItem().getType() == XMaterial.ENDER_PEARL.parseMaterial()) {
            this.nextPage();
            this.playSound(Menu.SoundType.CLICK);
        } else if (n == 30) {
            player.closeInventory();
            if (inventoryClickEvent.getClick() == ClickType.LEFT || inventoryClickEvent.getClick() == ClickType.SHIFT_LEFT) {
                new CraftIngredientCubeletConversation(this.getMain()).getConversation(player, craftParent, CraftType.CUBELET).begin();
            } else if (inventoryClickEvent.getClick() == ClickType.MIDDLE) {
                new CraftIngredientPointsConversation(this.getMain()).getConversation(player, craftParent, CraftType.POINTS).begin();
            } else if (inventoryClickEvent.getClick() == ClickType.RIGHT || inventoryClickEvent.getClick() == ClickType.SHIFT_RIGHT) {
                new CraftIngredientMoneyConversation(this.getMain()).getConversation(player, craftParent, CraftType.MONEY).begin();
            }
            this.playSound(Menu.SoundType.ANVIL_USE);
        } else if (n == 32) {
            new EditCraftingCraftsMenu(this.getMain(), player).open();
        } else if (n >= 10 && n <= 16 || n >= 19 && n <= 25) {
            if (inventoryClickEvent.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            if (this.getMain().getCubeletCraftingHandler().getCrafts().size() == 0) {
                return;
            }
            String string = NBTEditor.getString(inventoryClickEvent.getCurrentItem(), "ingredientUUID");
            Optional<CraftIngredient> optional = craftParent.getIngrediens().stream().filter(craftIngredient -> craftIngredient.getUuid().toString().equalsIgnoreCase(string)).findFirst();
            if (optional.isPresent()) {
                if (inventoryClickEvent.getClick() == ClickType.LEFT || inventoryClickEvent.getClick() == ClickType.SHIFT_LEFT) {
                    player.closeInventory();
                    CraftIngredient craftIngredient2 = optional.get();
                    if (craftIngredient2.getCraftType() == CraftType.CUBELET) {
                        new EditCraftIngredientCubeletConversation(this.getMain()).getConversation(player, craftParent, craftIngredient2).begin();
                    } else if (craftIngredient2.getCraftType() == CraftType.POINTS) {
                        new EditCraftIngredientPointsConversation(this.getMain()).getConversation(player, craftParent, craftIngredient2).begin();
                    } else if (craftIngredient2.getCraftType() == CraftType.MONEY) {
                        new EditCraftIngredientMoneyConversation(this.getMain()).getConversation(player, craftParent, craftIngredient2).begin();
                    }
                    this.playSound(Menu.SoundType.ANVIL_USE);
                } else if (inventoryClickEvent.getClick() == ClickType.RIGHT || inventoryClickEvent.getClick() == ClickType.SHIFT_RIGHT) {
                    craftParent.getIngrediens().remove(optional.get());
                    this.getMain().getCubeletCraftingHandler().saveCrafting();
                    this.reloadMenu();
                    this.playSound(Menu.SoundType.CLICK);
                }
            }
        }
    }

    @Override
    public void OnMenuClosed() {
    }

    private ItemStack getIconByIngredient(CraftIngredient craftIngredient) {
        if (craftIngredient.getCraftType() == CraftType.CUBELET) {
            return this.getMain().getCubeletTypesHandler().getTypeBydId(craftIngredient.getName()).getIcon();
        }
        if (craftIngredient.getCraftType() == CraftType.POINTS) {
            return XMaterial.POPPY.parseItem();
        }
        if (craftIngredient.getCraftType() == CraftType.MONEY) {
            return XMaterial.GOLD_INGOT.parseItem();
        }
        return XMaterial.BARRIER.parseItem();
    }
}

