/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.menus.admin.options;

import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.animations.AnimationHandler;
import me.davidml16.acubelets.animations.AnimationSettings;
import me.davidml16.acubelets.menus.admin.options.OptionsAnimationMenu;
import me.davidml16.acubelets.menus.admin.options.OptionsMainMenu;
import me.davidml16.acubelets.objects.GUILayout;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.utils.ItemBuilder;
import me.davidml16.acubelets.utils.Utils;
import me.davidml16.acubelets.utils.XSeries.XMaterial;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class OptionsAnimationsMenu
extends Menu {
    public OptionsAnimationsMenu(Main main, Player player) {
        super(main, player);
    }

    @Override
    public void OnPageOpened(int n) {
        Object object;
        Player player = this.getOwner();
        player.updateInventory();
        List<AnimationSettings> list = new ArrayList<AnimationSettings>(this.getMain().getAnimationHandler().getAnimations().values());
        Collections.sort(list);
        if (n < 0) {
            this.openPage(0);
            return;
        }
        if (n > 0 && list.size() < n * 21 + 1) {
            this.openPage(this.getPage() - 1);
            return;
        }
        if (list.size() > 21) {
            list = list.subList(n * 21, Math.min(n * 21 + 21, list.size()));
        }
        GUILayout gUILayout = this.getMain().getLayoutHandler().getLayout("animations");
        Inventory inventory = this.createInventory(45, "Options | Animations");
        ItemStack itemStack = new ItemBuilder(XMaterial.ARROW.parseItem()).setName(Utils.translate("&aBack to options")).toItemStack();
        itemStack = NBTEditor.set(itemStack, "back", "action");
        ItemStack itemStack2 = XMaterial.GRAY_STAINED_GLASS_PANE.parseItem();
        this.fillBorders(itemStack2);
        if (n > 0) {
            object = new ItemBuilder(XMaterial.ENDER_PEARL.parseMaterial(), 1).setName(Utils.translate("&aPrevious page")).toItemStack();
            object = NBTEditor.set(object, "previous", "action");
            inventory.setItem(18, (ItemStack)object);
        }
        if (this.getMain().getAnimationHandler().getAnimations().values().size() > (n + 1) * 21) {
            object = new ItemBuilder(XMaterial.ENDER_PEARL.parseMaterial(), 1).setName(Utils.translate("&aaNext page")).toItemStack();
            object = (ItemStack)NBTEditor.set(object, "next", "action");
            inventory.setItem(26, (ItemStack)object);
        }
        inventory.setItem(40, itemStack);
        for (AnimationSettings animationSettings : list) {
            ItemBuilder itemBuilder = new ItemBuilder(animationSettings.getDisplayItem()).hideAttributes().setName(Utils.translate((animationSettings.isEnabled() ? "&a" : "&c") + "Animation " + animationSettings.getAnimationNumber()));
            String[] stringArray = new String[7];
            stringArray[0] = "";
            stringArray[1] = Utils.translate(" &7ID: &6" + animationSettings.getId() + " ");
            stringArray[2] = Utils.translate(" &7Display Name: &6" + animationSettings.getFormatedDisplayName() + " ");
            stringArray[3] = Utils.translate(" &7Status: " + (animationSettings.isEnabled() ? "&aEnabled" : "&cDisabled") + " ");
            StringBuilder stringBuilder = new StringBuilder().append(" &7Default: ");
            this.getMain().getAnimationHandler();
            stringArray[4] = Utils.translate(stringBuilder.append(AnimationHandler.DEFAULT_ANIMATION.equalsIgnoreCase(animationSettings.getId()) ? "&atrue" : "&cfalse").append(" ").toString());
            stringArray[5] = "";
            stringArray[6] = Utils.translate("&eClick to edit settings ");
            ItemStack itemStack3 = itemBuilder.setLore(stringArray).toItemStack();
            itemStack3 = NBTEditor.set(itemStack3, animationSettings.getId(), "animation");
            itemStack3 = NBTEditor.set(itemStack3, "animation", "action");
            inventory.addItem(new ItemStack[]{itemStack3});
        }
        this.openInventory();
    }

    @Override
    public void OnMenuClick(InventoryClickEvent inventoryClickEvent) {
        inventoryClickEvent.setCancelled(true);
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        if (inventoryClickEvent.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        if (inventoryClickEvent.getClick() == ClickType.DOUBLE_CLICK) {
            return;
        }
        String string = NBTEditor.getString(inventoryClickEvent.getCurrentItem(), "action");
        if (string == null) {
            return;
        }
        Player player = this.getOwner();
        switch (string) {
            case "previous": {
                this.previousPage();
                break;
            }
            case "next": {
                this.nextPage();
                break;
            }
            case "animation": {
                String string2 = NBTEditor.getString(inventoryClickEvent.getCurrentItem(), "animation");
                AnimationSettings animationSettings = this.getMain().getAnimationHandler().getAnimationSetting(string2);
                if (animationSettings == null) {
                    return;
                }
                OptionsAnimationMenu optionsAnimationMenu = new OptionsAnimationMenu(this.getMain(), player);
                optionsAnimationMenu.setAttribute(Menu.AttrType.ANIMATION_SETTINGS_ATTR, animationSettings);
                optionsAnimationMenu.open();
                break;
            }
            case "back": {
                new OptionsMainMenu(this.getMain(), player).open();
            }
        }
    }

    @Override
    public void OnMenuClosed() {
    }
}

