/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.menus.admin.type;

import java.util.ArrayList;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.conversation.RenameConversation;
import me.davidml16.acubelets.conversation.TypeIconConversation;
import me.davidml16.acubelets.conversation.TypeKeyConversation;
import me.davidml16.acubelets.menus.admin.type.TypeConfigMenu;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.utils.ItemBuilder;
import me.davidml16.acubelets.utils.Utils;
import me.davidml16.acubelets.utils.XSeries.XMaterial;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class TypeSettingsMenu
extends Menu {
    public TypeSettingsMenu(Main main, Player player) {
        super(main, player);
    }

    @Override
    public void OnPageOpened(int n) {
        String string = (String)this.getAttribute(Menu.AttrType.CUSTOM_ID_ATTR);
        Inventory inventory = this.createInventory(45, "%cubelet_type% | Settings".replaceAll("%cubelet_type%", string));
        ItemStack itemStack = new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack();
        ItemStack itemStack2 = new ItemBuilder(XMaterial.ARROW.parseItem()).setName(Utils.translate("&aBack to config")).toItemStack();
        CubeletType cubeletType = this.getMain().getCubeletTypesHandler().getTypeBydId(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : cubeletType.getLoreAvailable()) {
            arrayList.add(Utils.translate(string2));
        }
        inventory.setItem(13, new ItemBuilder(XMaterial.NAME_TAG.parseItem()).setName(Utils.translate(cubeletType.getName())).setLore(arrayList).toItemStack());
        inventory.setItem(22, new ItemBuilder(cubeletType.getIcon()).setName(Utils.translate("&aCubelet type icon")).setLore("", Utils.translate(" &7You can change the "), Utils.translate(" &7icon clicking this item "), Utils.translate(" &7and opening icon setup "), "", Utils.translate("&eClick change skull texture! ")).toItemStack());
        inventory.setItem(20, new ItemBuilder(XMaterial.ANVIL.parseItem()).setName(Utils.translate("&aCubelet type name")).setLore("", Utils.translate(" &7Click on the anvil "), Utils.translate(" &7to start rename menu "), "", Utils.translate(" &7Choose 1 to rename cubelet type "), Utils.translate(" &7Choose 2 to save and exit menu. "), "", Utils.translate("&eClick to rename cubelet! ")).toItemStack());
        inventory.setItem(24, new ItemBuilder(XMaterial.TRIPWIRE_HOOK.parseItem()).addGlow().setName(Utils.translate("&aCubelet key")).setLore("", Utils.translate(" &7Open cubelets by "), Utils.translate(" &7holding a key in hand, "), Utils.translate(" &7a clicking a machine. "), "", Utils.translate("&eClick to change key item! ")).toItemStack());
        inventory.setItem(40, itemStack2);
        this.fillPage(itemStack);
        this.openInventory();
    }

    @Override
    public void OnMenuClick(InventoryClickEvent inventoryClickEvent) {
        inventoryClickEvent.setCancelled(true);
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        Player player = this.getOwner();
        int n = inventoryClickEvent.getRawSlot();
        String string = (String)this.getAttribute(Menu.AttrType.CUSTOM_ID_ATTR);
        CubeletType cubeletType = this.getMain().getCubeletTypesHandler().getTypeBydId(string);
        if (n == 20) {
            player.closeInventory();
            new RenameConversation(this.getMain()).getConversation(player, cubeletType).begin();
            this.playSound(Menu.SoundType.ANVIL_USE);
        } else if (n == 22) {
            player.closeInventory();
            new TypeIconConversation(this.getMain()).getConversation(player, cubeletType).begin();
            this.playSound(Menu.SoundType.ANVIL_USE);
        } else if (n == 24) {
            player.closeInventory();
            new TypeKeyConversation(this.getMain()).getConversation(player, cubeletType).begin();
            this.playSound(Menu.SoundType.ANVIL_USE);
        } else if (n == 40) {
            TypeConfigMenu typeConfigMenu = new TypeConfigMenu(this.getMain(), player);
            typeConfigMenu.setAttribute(Menu.AttrType.CUSTOM_ID_ATTR, string);
            typeConfigMenu.open();
        }
    }

    @Override
    public void OnMenuClosed() {
    }
}

