/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.utils.XSeries;

import java.awt.Color;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.davidml16.acubelets.utils.XSeries.XParticle;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.util.Vector;

public class ParticleDisplay
implements Cloneable {
    private static final boolean ISFLAT = XParticle.getParticle("FOOTSTEP") == null;
    private static final Axis[] DEFAULT_ROTATION_ORDER = new Axis[]{Axis.X, Axis.Y, Axis.Z};
    private static final Particle DEFAULT_PARTICLE = Particle.CLOUD;
    public int count;
    public double extra;
    public boolean force;
    @Nonnull
    private Particle particle = DEFAULT_PARTICLE;
    @Nullable
    private Location location;
    @Nullable
    private Callable<Location> locationCaller;
    @Nullable
    private Vector rotation;
    @Nullable
    private Vector offset = new Vector();
    @Nonnull
    private Axis[] rotationOrder = DEFAULT_ROTATION_ORDER;
    @Nullable
    private Object data;
    @Nullable
    private Predicate<Location> onSpawn;

    @Nonnull
    public static ParticleDisplay colored(@Nullable Location location, int n, int n2, int n3, float f) {
        return ParticleDisplay.simple(location, Particle.REDSTONE).withColor(n, n2, n3, f);
    }

    @Nonnull
    public static ParticleDisplay colored(@Nullable Location location, @Nonnull Color color, float f) {
        return ParticleDisplay.colored(location, color.getRed(), color.getGreen(), color.getBlue(), f);
    }

    @Nonnull
    public static ParticleDisplay simple(@Nullable Location location, @Nonnull Particle particle) {
        Objects.requireNonNull(particle, "Cannot build ParticleDisplay with null particle");
        ParticleDisplay particleDisplay = new ParticleDisplay();
        particleDisplay.particle = particle;
        particleDisplay.location = location;
        return particleDisplay;
    }

    @Nonnull
    public static ParticleDisplay of(@Nonnull Particle particle) {
        return ParticleDisplay.simple(null, particle);
    }

    @Nonnull
    public static ParticleDisplay display(@Nonnull Location location, @Nonnull Particle particle) {
        Objects.requireNonNull(location, "Cannot display particle in null location");
        ParticleDisplay particleDisplay = ParticleDisplay.simple(location, particle);
        particleDisplay.spawn();
        return particleDisplay;
    }

    public static ParticleDisplay fromConfig(@Nonnull ConfigurationSection configurationSection) {
        return ParticleDisplay.edit(new ParticleDisplay(), configurationSection);
    }

    @Nonnull
    public static ParticleDisplay edit(@Nonnull ParticleDisplay particleDisplay, @Nonnull ConfigurationSection configurationSection) {
        Object object;
        String string;
        String[] stringArray;
        String[] stringArray2;
        String string2;
        Particle particle;
        Objects.requireNonNull(particleDisplay, "Cannot edit a null particle display");
        Objects.requireNonNull(configurationSection, "Cannot parse ParticleDisplay from a null config section");
        String string3 = configurationSection.getString("particle");
        Particle particle2 = particle = string3 == null ? null : XParticle.getParticle(string3);
        if (particle != null) {
            particleDisplay.particle = particle;
        }
        if (configurationSection.isSet("count")) {
            particleDisplay.withCount(configurationSection.getInt("count"));
        }
        if (configurationSection.isSet("extra")) {
            particleDisplay.withExtra(configurationSection.getDouble("extra"));
        }
        if (configurationSection.isSet("force")) {
            particleDisplay.forceSpawn(configurationSection.getBoolean("force"));
        }
        if ((string2 = configurationSection.getString("offset")) != null) {
            double d;
            stringArray2 = StringUtils.split((String)StringUtils.deleteWhitespace((String)string2), (char)',');
            if (stringArray2.length >= 3) {
                d = NumberUtils.toDouble((String)stringArray2[0]);
                double d2 = NumberUtils.toDouble((String)stringArray2[1]);
                double d3 = NumberUtils.toDouble((String)stringArray2[2]);
                particleDisplay.offset(d, d2, d3);
            } else {
                d = NumberUtils.toDouble((String)stringArray2[0]);
                particleDisplay.offset(d);
            }
        }
        if ((stringArray2 = configurationSection.getString("rotation")) != null && (stringArray = StringUtils.split((String)StringUtils.deleteWhitespace((String)stringArray2), (char)',')).length >= 3) {
            double d = Math.toRadians(NumberUtils.toDouble((String)stringArray[0]));
            double d4 = Math.toRadians(NumberUtils.toDouble((String)stringArray[1]));
            double d5 = Math.toRadians(NumberUtils.toDouble((String)stringArray[2]));
            particleDisplay.rotation = new Vector(d, d4, d5);
        }
        if ((string = configurationSection.getString("rotation-order")) != null) {
            string = StringUtils.deleteWhitespace((String)string).toUpperCase(Locale.ENGLISH);
            particleDisplay.rotationOrder(Axis.valueOf(String.valueOf(string.charAt(0))), Axis.valueOf(String.valueOf(string.charAt(1))), Axis.valueOf(String.valueOf(string.charAt(2))));
        }
        String string4 = configurationSection.getString("color");
        String string5 = configurationSection.getString("blockdata");
        String string6 = configurationSection.getString("itemstack");
        String string7 = configurationSection.getString("materialdata");
        float f = 1.0f;
        if (particleDisplay.data instanceof float[] && ((float[])(object = (float[])particleDisplay.data)).length >= 4) {
            if (configurationSection.isSet("size")) {
                object[3] = f = (float)configurationSection.getDouble("size");
            } else {
                f = object[3];
            }
        }
        if (string4 != null) {
            object = StringUtils.split((String)StringUtils.deleteWhitespace((String)string4), (char)',');
            if (((float[])object).length == 1 || ((float[])object).length == 3) {
                Color color = Color.white;
                if (((float[])object).length == 1) {
                    try {
                        color = Color.decode((String)object[0]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    color = new Color(NumberUtils.toInt((String)object[0]), NumberUtils.toInt((String)object[1]), NumberUtils.toInt((String)object[2]));
                }
                particleDisplay.data = new float[]{color.getRed(), color.getGreen(), color.getBlue(), f};
            }
        } else if (string5 != null) {
            object = Material.getMaterial((String)string5);
            if (object != null && object.isBlock()) {
                particleDisplay.data = object.createBlockData();
            }
        } else if (string6 != null) {
            object = Material.getMaterial((String)string6);
            if (object != null && object.isItem()) {
                particleDisplay.data = new ItemStack((Material)object, 1);
            }
        } else if (string7 != null && (object = (Object)Material.getMaterial((String)string7)) != null && object.isBlock()) {
            particleDisplay.data = object.getData();
        }
        return particleDisplay;
    }

    @Nonnull
    private static Location cloneLocation(@Nonnull Location location) {
        return new Location(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public static Vector rotateAround(@Nonnull Vector vector, @Nonnull Axis axis, @Nonnull Vector vector2) {
        Objects.requireNonNull(axis, "Cannot rotate around null axis");
        Objects.requireNonNull(vector2, "Rotation vector cannot be null");
        switch (axis) {
            case X: {
                return ParticleDisplay.rotateAround(vector, axis, vector2.getX());
            }
            case Y: {
                return ParticleDisplay.rotateAround(vector, axis, vector2.getY());
            }
            case Z: {
                return ParticleDisplay.rotateAround(vector, axis, vector2.getZ());
            }
        }
        throw new AssertionError((Object)("Unknown rotation axis: " + (Object)((Object)axis)));
    }

    public static Vector rotateAround(@Nonnull Vector vector, double d, double d2, double d3) {
        ParticleDisplay.rotateAround(vector, Axis.X, d);
        ParticleDisplay.rotateAround(vector, Axis.Y, d2);
        ParticleDisplay.rotateAround(vector, Axis.Z, d3);
        return vector;
    }

    public static Vector rotateAround(@Nonnull Vector vector, @Nonnull Axis axis, double d) {
        Objects.requireNonNull(vector, "Cannot rotate a null location");
        Objects.requireNonNull(axis, "Cannot rotate around null axis");
        if (d == 0.0) {
            return vector;
        }
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        switch (axis) {
            case X: {
                double d4 = vector.getY() * d2 - vector.getZ() * d3;
                double d5 = vector.getY() * d3 + vector.getZ() * d2;
                return vector.setY(d4).setZ(d5);
            }
            case Y: {
                double d6 = vector.getX() * d2 + vector.getZ() * d3;
                double d7 = vector.getX() * -d3 + vector.getZ() * d2;
                return vector.setX(d6).setZ(d7);
            }
            case Z: {
                double d8 = vector.getX() * d2 - vector.getY() * d3;
                double d9 = vector.getX() * d3 + vector.getY() * d2;
                return vector.setX(d8).setY(d9);
            }
        }
        throw new AssertionError((Object)("Unknown rotation axis: " + (Object)((Object)axis)));
    }

    public ParticleDisplay onSpawn(@Nullable Predicate<Location> predicate) {
        this.onSpawn = predicate;
        return this;
    }

    public void withParticle(@Nonnull Particle particle) {
        this.particle = Objects.requireNonNull(particle, "Particle cannot be null");
    }

    @Nonnull
    public Location rotate(@Nonnull Location location, double d, double d2, double d3) {
        if (location == null) {
            throw new IllegalStateException("Attempting to spawn particle when no location is set");
        }
        if (this.rotation == null) {
            return ParticleDisplay.cloneLocation(location).add(d, d2, d3);
        }
        Vector vector = new Vector(d, d2, d3);
        ParticleDisplay.rotateAround(vector, this.rotationOrder[0], this.rotation);
        ParticleDisplay.rotateAround(vector, this.rotationOrder[1], this.rotation);
        ParticleDisplay.rotateAround(vector, this.rotationOrder[2], this.rotation);
        return ParticleDisplay.cloneLocation(location).add(vector);
    }

    @Nullable
    public Object getData() {
        return this.data;
    }

    public String toString() {
        Location location = this.getLocation();
        return "ParticleDisplay:[Particle=" + this.particle + ", Count=" + this.count + ", Offset:{" + this.offset.getX() + ", " + this.offset.getY() + ", " + this.offset.getZ() + "}, " + (location != null ? "Location:{" + location.getWorld().getName() + location.getX() + ", " + location.getY() + ", " + location.getZ() + "} " + '(' + (this.locationCaller == null ? "Static" : "Dynamic") + "), " : "") + (this.rotation != null ? "Rotation:{" + Math.toDegrees(this.rotation.getX()) + ", " + Math.toRadians(this.rotation.getY()) + ", " + Math.toDegrees(this.rotation.getZ()) + "}, " : "") + (this.rotationOrder != DEFAULT_ROTATION_ORDER ? "RotationOrder:" + Arrays.toString((Object[])this.rotationOrder) + ", " : "") + "Extra=" + this.extra + ", Force=" + this.force + ", Data=" + (this.data == null ? "null" : (this.data instanceof float[] ? Arrays.toString((float[])this.data) : this.data));
    }

    @Nonnull
    public ParticleDisplay withCount(int n) {
        this.count = n;
        return this;
    }

    @Nonnull
    public ParticleDisplay withExtra(double d) {
        this.extra = d;
        return this;
    }

    @Nonnull
    public ParticleDisplay forceSpawn(boolean bl) {
        this.force = bl;
        return this;
    }

    @Nonnull
    public ParticleDisplay withColor(@Nonnull Color color, float f) {
        return this.withColor(color.getRed(), color.getGreen(), color.getBlue(), f);
    }

    @Nonnull
    public ParticleDisplay withColor(float f, float f2, float f3, float f4) {
        this.data = new float[]{f, f2, f3, f4};
        return this;
    }

    @Nonnull
    public ParticleDisplay withBlock(@Nonnull BlockData blockData) {
        this.data = blockData;
        return this;
    }

    @Nonnull
    public ParticleDisplay withBlock(@Nonnull MaterialData materialData) {
        this.data = materialData;
        return this;
    }

    @Nonnull
    public ParticleDisplay withItem(@Nonnull ItemStack itemStack) {
        this.data = itemStack;
        return this;
    }

    @Nullable
    public Vector getOffset() {
        return this.offset;
    }

    @Nonnull
    public ParticleDisplay withEntity(@Nonnull Entity entity) {
        return this.withLocationCaller(() -> ((Entity)entity).getLocation());
    }

    @Nonnull
    public ParticleDisplay withLocationCaller(@Nullable Callable<Location> callable) {
        this.locationCaller = callable;
        return this;
    }

    public ParticleDisplay rotationOrder(@Nonnull Axis axis, @Nonnull Axis axis2, @Nonnull Axis axis3) {
        Objects.requireNonNull(axis, "First rotation order axis is null");
        Objects.requireNonNull(axis2, "Second rotation order axis is null");
        Objects.requireNonNull(axis3, "Third rotation order axis is null");
        this.rotationOrder = new Axis[]{axis, axis2, axis3};
        return this;
    }

    @Nullable
    public Location getLocation() {
        try {
            return this.locationCaller == null ? this.location : this.locationCaller.call();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.location;
        }
    }

    public ParticleDisplay withLocation(@Nullable Location location) {
        this.location = location;
        return this;
    }

    @Nonnull
    public ParticleDisplay face(@Nonnull Entity entity) {
        return this.face(Objects.requireNonNull(entity, "Cannot face null entity").getLocation());
    }

    @Nonnull
    public ParticleDisplay face(@Nonnull Location location) {
        Objects.requireNonNull(location, "Cannot face null location");
        this.rotation = new Vector(Math.toRadians(location.getPitch() + 90.0f), Math.toRadians(-location.getYaw()), 0.0);
        return this;
    }

    @Nullable
    public Location cloneLocation(double d, double d2, double d3) {
        return this.location == null ? null : ParticleDisplay.cloneLocation(this.location).add(d, d2, d3);
    }

    @Nonnull
    public ParticleDisplay cloneWithLocation(double d, double d2, double d3) {
        ParticleDisplay particleDisplay = this.clone();
        if (this.location == null) {
            return particleDisplay;
        }
        particleDisplay.location.add(d, d2, d3);
        return particleDisplay;
    }

    @Nonnull
    public ParticleDisplay clone() {
        ParticleDisplay particleDisplay = ParticleDisplay.of(this.particle).withLocationCaller(this.locationCaller).withCount(this.count).offset(this.offset.clone()).forceSpawn(this.force).onSpawn(this.onSpawn);
        if (this.location != null) {
            particleDisplay.location = ParticleDisplay.cloneLocation(this.location);
        }
        if (this.rotation != null) {
            particleDisplay.rotation = this.rotation.clone();
        }
        particleDisplay.rotationOrder = this.rotationOrder;
        particleDisplay.data = this.data;
        return particleDisplay;
    }

    @Nonnull
    public ParticleDisplay rotate(@Nonnull Vector vector) {
        Objects.requireNonNull(vector, "Cannot rotate ParticleDisplay with null vector");
        if (this.rotation == null) {
            this.rotation = vector;
        } else {
            this.rotation.add(vector);
        }
        return this;
    }

    @Nonnull
    public ParticleDisplay rotate(double d, double d2, double d3) {
        return this.rotate(new Vector(d, d2, d3));
    }

    @Nonnull
    public ParticleDisplay offset(double d, double d2, double d3) {
        return this.offset(new Vector(d, d2, d3));
    }

    @Nonnull
    public ParticleDisplay offset(@Nonnull Vector vector) {
        this.offset = Objects.requireNonNull(vector, "Particle offset cannot be null");
        return this;
    }

    @Nullable
    public Vector getRotation() {
        return this.rotation;
    }

    public void setRotation(@Nullable Vector vector) {
        this.rotation = vector;
    }

    @Nonnull
    public ParticleDisplay offset(double d) {
        return this.offset(d, d, d);
    }

    @Nonnull
    public ParticleDisplay directional() {
        this.count = 0;
        return this;
    }

    public boolean isDirectional() {
        return this.count == 0;
    }

    public void spawn() {
        this.spawn(this.getLocation());
    }

    @Nonnull
    public Location spawn(@Nonnull Vector vector) {
        Objects.requireNonNull(vector, "Cannot add xyz of null vector to ParticleDisplay");
        return this.spawn(vector.getX(), vector.getY(), vector.getZ());
    }

    @Nonnull
    public Location spawn(double d, double d2, double d3) {
        return this.spawn(this.rotate(this.getLocation(), d, d2, d3));
    }

    @Nonnull
    public Location spawn(@Nonnull Location location) {
        return this.spawn(location, null);
    }

    @Nonnull
    public Location spawn(@Nonnull Location location, Player ... playerArray) {
        if (location == null) {
            throw new IllegalStateException("Attempting to spawn particle when no location is set");
        }
        if (this.onSpawn != null && !this.onSpawn.test(location)) {
            return location;
        }
        World world = location.getWorld();
        double d = this.offset.getX();
        double d2 = this.offset.getY();
        double d3 = this.offset.getZ();
        if (this.data != null && this.data instanceof float[]) {
            float[] fArray = (float[])this.data;
            if (ISFLAT && this.particle.getDataType() == Particle.DustOptions.class) {
                Particle.DustOptions dustOptions = new Particle.DustOptions(org.bukkit.Color.fromRGB((int)((int)fArray[0]), (int)((int)fArray[1]), (int)((int)fArray[2])), fArray[3]);
                if (playerArray == null) {
                    world.spawnParticle(this.particle, location, this.count, d, d2, d3, this.extra, (Object)dustOptions, this.force);
                } else {
                    for (Player player : playerArray) {
                        player.spawnParticle(this.particle, location, this.count, d, d2, d3, this.extra, (Object)dustOptions);
                    }
                }
            } else if (this.isDirectional()) {
                float[] fArray2 = new float[]{fArray[0] / 255.0f, fArray[1] / 255.0f, fArray[2] / 255.0f};
                if (playerArray == null) {
                    if (ISFLAT) {
                        world.spawnParticle(this.particle, location, this.count, (double)fArray2[0], (double)fArray2[1], (double)fArray2[2], (double)fArray[3], null, this.force);
                    } else {
                        world.spawnParticle(this.particle, location, this.count, (double)fArray2[0], (double)fArray2[1], (double)fArray2[2], (double)fArray[3], null);
                    }
                } else {
                    for (Player player : playerArray) {
                        player.spawnParticle(this.particle, location, this.count, (double)fArray2[0], (double)fArray2[1], (double)fArray2[2], (double)fArray[3]);
                    }
                }
            } else if (playerArray == null) {
                if (ISFLAT) {
                    world.spawnParticle(this.particle, location, this.count, d, d2, d3, this.extra, null, this.force);
                } else {
                    world.spawnParticle(this.particle, location, this.count, d, d2, d3, this.extra, null);
                }
            } else {
                for (Player player : playerArray) {
                    player.spawnParticle(this.particle, location, this.count, d, d2, d3, this.extra);
                }
            }
        } else {
            Object object;
            Object object2 = object = this.particle.getDataType().isInstance(this.data) ? this.data : null;
            if (playerArray == null) {
                if (ISFLAT) {
                    world.spawnParticle(this.particle, location, this.count, d, d2, d3, this.extra, object, this.force);
                } else {
                    world.spawnParticle(this.particle, location, this.count, d, d2, d3, this.extra, object);
                }
            } else {
                for (Player player : playerArray) {
                    player.spawnParticle(this.particle, location, this.count, d, d2, d3, this.extra, object);
                }
            }
        }
        return location;
    }

    public static enum Axis {
        X,
        Y,
        Z;

    }
}

