/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.utils.XSeries;

import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Base64;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.davidml16.acubelets.utils.XSeries.XMaterial;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class SkullUtils {
    private static final String VALUE_PROPERTY = "{\"textures\":{\"SKIN\":{\"url\":\"";
    private static final String TEXTURES = "https://textures.minecraft.net/texture/";
    private static final String SESSION = "https://sessionserver.mojang.com/session/minecraft/profile/";
    private static final Pattern BASE64 = Pattern.compile("(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)?");
    private static final Pattern USERNAME = Pattern.compile("[A-z0-9]+");

    @Nonnull
    public static ItemStack getSkull(@Nonnull UUID uUID) {
        ItemStack itemStack = XMaterial.PLAYER_HEAD.parseItem();
        SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
        if (XMaterial.isNewVersion()) {
            skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)uUID));
        } else {
            skullMeta.setOwner(uUID.toString());
        }
        itemStack.setItemMeta((ItemMeta)skullMeta);
        return itemStack;
    }

    @Nonnull
    public static SkullMeta applySkin(@Nonnull ItemMeta itemMeta, @Nonnull String string) {
        boolean bl = SkullUtils.isUUID(SkullUtils.getFullUUID(string));
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        if (bl || SkullUtils.isUsername(string)) {
            if (bl) {
                return SkullUtils.getSkullByValue(skullMeta, SkullUtils.getSkinValue(string, true));
            }
            if (XMaterial.isNewVersion()) {
                skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)string));
            } else {
                skullMeta.setOwner(string);
            }
        }
        if (string.contains("textures.minecraft.net")) {
            return SkullUtils.getValueFromTextures(skullMeta, string);
        }
        if (string.length() > 100 && SkullUtils.isBase64(string)) {
            return SkullUtils.getSkullByValue(skullMeta, string);
        }
        return SkullUtils.getTexturesFromUrlValue(skullMeta, string);
    }

    @Nonnull
    public static SkullMeta getSkullByValue(@Nonnull SkullMeta skullMeta, @Nonnull String string) {
        Validate.notEmpty((String)string, (String)"Skull value cannot be null or empty");
        GameProfile gameProfile = new GameProfile(UUID.randomUUID(), null);
        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", string));
        try {
            Field field = skullMeta.getClass().getDeclaredField("profile");
            field.setAccessible(true);
            field.set(skullMeta, gameProfile);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException exception) {
            exception.printStackTrace();
        }
        return skullMeta;
    }

    @Nonnull
    public static SkullMeta getValueFromTextures(@Nonnull SkullMeta skullMeta, @Nonnull String string) {
        return SkullUtils.getSkullByValue(skullMeta, SkullUtils.encodeBase64(VALUE_PROPERTY + string + "\"}}}"));
    }

    @Nonnull
    public static SkullMeta getTexturesFromUrlValue(@Nonnull SkullMeta skullMeta, @Nonnull String string) {
        return SkullUtils.getValueFromTextures(skullMeta, TEXTURES + string);
    }

    @Nonnull
    private static String encodeBase64(@Nonnull String string) {
        return Base64.getEncoder().encodeToString(string.getBytes());
    }

    private static boolean isBase64(String string) {
        return BASE64.matcher(string).matches();
    }

    public static String getSkinValue(@Nonnull ItemStack itemStack) {
        Objects.requireNonNull(itemStack, "Skull ItemStack cannot be null");
        SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
        GameProfile gameProfile = null;
        try {
            Field field = skullMeta.getClass().getDeclaredField("profile");
            field.setAccessible(true);
            gameProfile = (GameProfile)field.get(skullMeta);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException exception) {
            exception.printStackTrace();
        }
        if (gameProfile != null && !gameProfile.getProperties().get((Object)"textures").isEmpty()) {
            for (Property property : gameProfile.getProperties().get((Object)"textures")) {
                if (property.getValue().isEmpty()) continue;
                return property.getValue();
            }
        }
        return null;
    }

    @Nullable
    private static String getFullUUID(@Nullable String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return string;
        }
        if (string.length() == 36) {
            return string;
        }
        if (string.length() != 32) {
            return string;
        }
        return string.substring(0, 8) + "-" + string.substring(8, 12) + "-" + string.substring(12, 16) + "-" + string.substring(16, 20) + "-" + string.substring(20, 32);
    }

    private static boolean isUUID(@Nullable String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return false;
        }
        return string.length() == 36 && StringUtils.countMatches((String)string, (String)"-") == 4;
    }

    private static boolean isUsername(@Nullable String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return false;
        }
        return string.length() >= 3 && string.length() <= 16 && USERNAME.matcher(string).matches();
    }

    @Nonnull
    public static String getSkinValue(@Nonnull String string, boolean bl) {
        Validate.notEmpty((String)string, (String)"Player name/UUID cannot be null or empty");
        try {
            String string2;
            JsonObject jsonObject;
            InputStreamReader inputStreamReader;
            URL uRL;
            JsonParser jsonParser = new JsonParser();
            if (!bl) {
                uRL = new URL("https://api.mojang.com/users/profiles/minecraft/" + string);
                inputStreamReader = new InputStreamReader(uRL.openStream());
                jsonObject = jsonParser.parse((Reader)inputStreamReader).getAsJsonObject();
                if (SkullUtils.mojangError(jsonObject)) {
                    return null;
                }
                string2 = jsonObject.get("id").getAsString();
            } else {
                string2 = StringUtils.remove((String)string, (char)'-');
            }
            uRL = new URL(SESSION + string2);
            inputStreamReader = new InputStreamReader(uRL.openStream());
            jsonObject = jsonParser.parse((Reader)inputStreamReader).getAsJsonObject();
            if (SkullUtils.mojangError(jsonObject)) {
                return null;
            }
            JsonObject jsonObject2 = jsonObject.get("properties").getAsJsonArray().get(0).getAsJsonObject();
            return jsonObject2.get("value").getAsString();
        }
        catch (IOException | IllegalStateException exception) {
            System.err.println("Could not get skin data from session servers! " + exception.getMessage());
            exception.printStackTrace();
            return null;
        }
    }

    private static boolean mojangError(JsonObject jsonObject) {
        if (!jsonObject.has("error")) {
            return false;
        }
        String string = jsonObject.get("error").getAsString();
        String string2 = jsonObject.get("errorMessage").getAsString();
        System.err.println("Mojang Error " + string + ": " + string2);
        return true;
    }
}

