/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.animations.animation.animation18;

import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.util.List;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.objects.rewards.Reward;
import me.davidml16.acubelets.utils.LocationUtils;
import me.davidml16.acubelets.utils.Sounds;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.EulerAngle;

public class Animation18_Item
extends BukkitRunnable {
    private final ArmorStand armorStandItem;
    private final ArmorStand armorStandName;
    private Location center;
    private Reward reward;
    private int step = 0;
    private int circleStep = 0;
    private double circleSize = 0.0;

    public Animation18_Item(Main main, Reward reward, Location location) {
        this.center = location;
        this.reward = reward;
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawn(location, ArmorStand.class);
        NBTEditor.set(armorStand, (byte)1, "Silent");
        armorStand.setSilent(true);
        armorStand.setVisible(false);
        armorStand.setGravity(false);
        armorStand.setItemInHand(reward.getIcon());
        armorStand.setRightArmPose(new EulerAngle(Math.toRadians(-95.0), Math.toRadians(-90.0), Math.toRadians(80.0)));
        armorStand.setSmall(false);
        armorStand.setMarker(false);
        armorStand.setRemoveWhenFarAway(false);
        armorStand.setCustomNameVisible(false);
        armorStand.setMetadata("ACUBELETS", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)Boolean.TRUE));
        armorStand.teleport(location);
        main.getAnimationHandler().getEntities().add((Entity)armorStand);
        ArmorStand armorStand2 = (ArmorStand)location.getWorld().spawn(location.clone().add(0.0, 0.45, 0.0), ArmorStand.class);
        NBTEditor.set(armorStand2, (byte)1, "Silent");
        armorStand2.setSilent(true);
        armorStand2.setVisible(false);
        armorStand2.setGravity(false);
        armorStand2.setHelmet(null);
        armorStand2.setSmall(true);
        armorStand2.setMarker(false);
        armorStand2.setRemoveWhenFarAway(false);
        armorStand2.setCustomName(Utils.translate(reward.getName()));
        armorStand2.setCustomNameVisible(true);
        armorStand2.setMetadata("ACUBELETS", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)Boolean.TRUE));
        armorStand2.teleport(location.clone().add(0.0, 0.45, 0.0));
        main.getAnimationHandler().getEntities().add((Entity)armorStand2);
        Sounds.playSound(armorStand.getLocation(), Sounds.MySound.ORB_PICKUP, 0.5f, 3.0f);
        this.armorStandItem = armorStand;
        this.armorStandName = armorStand2;
    }

    public ArmorStand getArmorStandItem() {
        return this.armorStandItem;
    }

    public ArmorStand getArmorStandName() {
        return this.armorStandName;
    }

    public Reward getReward() {
        return this.reward;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int n) {
        this.step = n;
    }

    public void run() {
        if (this.step <= 20) {
            this.circleSize += 0.125;
        }
        List<Location> list = LocationUtils.getCircle(this.center.clone(), this.circleSize, 73);
        Location location = list.get(this.circleStep).clone();
        if (this.circleStep + 1 >= list.size()) {
            location.setDirection(list.get(0).clone().toVector().subtract(location.toVector()));
        } else {
            location.setDirection(list.get(this.circleStep + 1).clone().toVector().subtract(location.toVector()));
        }
        this.armorStandItem.teleport(location);
        this.armorStandName.teleport(location.clone().add(0.0, 0.45, 0.0));
        ++this.circleStep;
        if (this.circleStep >= list.size()) {
            this.circleStep = 0;
        }
        ++this.step;
    }
}

