/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.handlers;

import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.animations.Animation;
import me.davidml16.acubelets.animations.AnimationHandler;
import me.davidml16.acubelets.animations.AnimationSettings;
import me.davidml16.acubelets.objects.CubeletMachine;
import me.davidml16.acubelets.objects.CubeletOpener;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.Profile;
import org.bukkit.entity.Player;

public class CubeletOpenHandler {
    private Main main;

    public CubeletOpenHandler(Main main) {
        this.main = main;
    }

    public void openAnimation(Player player, CubeletMachine cubeletMachine, CubeletType cubeletType, boolean bl) {
        if (cubeletMachine.isWaiting()) {
            Animation animation;
            CubeletOpener cubeletOpener = new CubeletOpener(player.getUniqueId(), player.getName());
            cubeletMachine.setPlayerOpening(cubeletOpener);
            this.main.getHologramImplementation().clearLines(cubeletMachine);
            if (!this.main.isAnimationByPlayer() || bl) {
                animation = !cubeletType.getAnimation().equalsIgnoreCase("random") ? this.main.getAnimationHandler().getAnimation(cubeletType.getAnimation()) : this.main.getAnimationHandler().getAnimation(this.main.getAnimationHandler().getRandomAnimation().getId());
            } else {
                Profile profile = this.main.getPlayerDataHandler().getData(player);
                if (!profile.getAnimation().equalsIgnoreCase("random")) {
                    AnimationSettings animationSettings = this.main.getAnimationHandler().getAnimationSetting(profile.getAnimation());
                    if (animationSettings.isNeedPermission() && !this.main.getAnimationHandler().haveAnimationPermission(player, animationSettings)) {
                        profile.setAnimation(AnimationHandler.DEFAULT_ANIMATION);
                    }
                    animation = this.main.getAnimationHandler().getAnimation(profile.getAnimation());
                } else {
                    animation = this.main.getAnimationHandler().getAnimation(this.main.getAnimationHandler().getRandomAnimation(player).getId());
                }
            }
            animation.setCubeletBox(cubeletMachine);
            animation.setCubeletType(cubeletType);
            animation.start();
        } else if (cubeletMachine.getPlayerOpening().getUuid() == player.getUniqueId()) {
            player.sendMessage(this.main.getLanguageHandler().getMessage("Cubelet.BoxInUse.Me"));
        } else {
            player.sendMessage(this.main.getLanguageHandler().getMessage("Cubelet.BoxInUse.Other").replaceAll("%player%", cubeletMachine.getPlayerOpening().getName()));
        }
    }
}

