/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.handlers;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.animations.AnimationHandler;
import me.davidml16.acubelets.objects.Cubelet;
import me.davidml16.acubelets.objects.Profile;
import me.davidml16.acubelets.objects.loothistory.LootHistory;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlayerDataHandler {
    public HashMap<UUID, Profile> data = new HashMap();
    public HashMap<UUID, Long> disconnectCacheTime = new HashMap();
    private Main main;

    public PlayerDataHandler(Main main) {
        this.main = main;
    }

    public HashMap<UUID, Profile> getPlayersData() {
        return this.data;
    }

    public HashMap<UUID, Long> getDisconnectCacheTime() {
        return this.disconnectCacheTime;
    }

    public Profile getData(Player player) {
        if (this.data.containsKey(player.getUniqueId())) {
            return this.data.get(player.getUniqueId());
        }
        return null;
    }

    public Profile getData(UUID uUID) {
        if (this.data.containsKey(uUID)) {
            return this.data.get(uUID);
        }
        return null;
    }

    public Long getDisconnectTime(UUID uUID) {
        if (this.disconnectCacheTime.containsKey(uUID)) {
            return this.disconnectCacheTime.get(uUID);
        }
        return null;
    }

    public void addDisconnectTime(UUID uUID, Long l) {
        this.disconnectCacheTime.put(uUID, l);
    }

    public boolean playerExists(Player player) {
        return this.data.containsKey(player.getUniqueId());
    }

    public void loadPlayerData(Player player) {
        Profile profile = new Profile(this.main, player.getUniqueId());
        this.data.put(player.getUniqueId(), profile);
        try {
            this.main.getDatabaseHandler().hasName(player.getName(), string2 -> {
                if (string2 == null) {
                    this.main.getDatabaseHandler().createPlayerData(player);
                    profile.setOrderBy("date");
                    profile.setLootPoints(0L);
                    profile.setAnimation("animation2");
                } else {
                    this.main.getDatabaseHandler().updatePlayerName(player);
                    this.main.getDatabaseHandler().getPlayerOrderSetting(player.getUniqueId(), profile::setOrderBy);
                    this.main.getDatabaseHandler().getPlayerLootPoints(player.getUniqueId(), profile::setLootPoints);
                    this.main.getDatabaseHandler().getPlayerAnimation(player.getUniqueId(), string -> {
                        if (string.contains("animation")) {
                            profile.setAnimation((String)string);
                        } else {
                            profile.setAnimation(AnimationHandler.DEFAULT_ANIMATION);
                        }
                    });
                }
                this.main.getDatabaseHandler().removeExpiredCubelets(player.getUniqueId());
                this.main.getDatabaseHandler().getCubelets(player.getUniqueId()).thenAccept(list -> {
                    profile.setCubelets((List<Cubelet>)list);
                    Bukkit.getScheduler().runTaskLater((Plugin)this.main, () -> this.main.getHologramImplementation().reloadHolograms(player), 2L);
                    if (this.main.isLoginReminder()) {
                        Bukkit.getScheduler().runTaskLater((Plugin)this.main, () -> {
                            if (list.size() > 0) {
                                for (String string : this.main.getLanguageHandler().getMessageList("Cubelet.LoginReminder")) {
                                    string = string.replaceAll("%amount%", Integer.toString(list.size()));
                                    string = string.replaceAll("%player%", player.getName());
                                    player.sendMessage(string);
                                }
                            }
                        }, 20L);
                    }
                });
                this.main.getDatabaseHandler().getLootHistory(player.getUniqueId()).thenAccept(list -> profile.setLootHistory((List<LootHistory>)list));
            });
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public void loadAllPlayerData() {
        this.data.clear();
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            this.loadPlayerData(player);
        }
    }

    public void saveAllPlayerDataAsync() {
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            this.main.getDatabaseHandler().saveProfileAsync(this.getData(player));
        }
    }

    public void saveAllPlayerDataSync() {
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            this.main.getDatabaseHandler().saveProfileSync(this.getData(player));
        }
    }
}

