/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.menus.admin;

import com.cryptomorin.xseries.XMaterial;
import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.animations.AnimationHandler;
import me.davidml16.acubelets.animations.AnimationSettings;
import me.davidml16.acubelets.menus.admin.type.TypeConfigMenu;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.GUILayout;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.objects.Profile;
import me.davidml16.acubelets.utils.ItemBuilder;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class AnimationsMenu
extends Menu {
    public AnimationsMenu(Main main, Player player) {
        super(main, player);
    }

    @Override
    public void OnPageOpened(int n) {
        Object object;
        List list;
        Player player = this.getOwner();
        player.updateInventory();
        Profile profile = this.getMain().getPlayerDataHandler().getData(player);
        if (!profile.getAnimation().equalsIgnoreCase("random") && ((AnimationSettings)((Object)(list = this.getMain().getAnimationHandler().getAnimationSetting(profile.getAnimation())))).isNeedPermission() && !this.getMain().getAnimationHandler().haveAnimationPermission(player, (AnimationSettings)((Object)list))) {
            profile.setAnimation(AnimationHandler.DEFAULT_ANIMATION);
        }
        list = new ArrayList<AnimationSettings>(this.getMain().getAnimationHandler().getAnimations().values());
        Collections.sort(list);
        if (n < 0) {
            this.openPage(0);
            return;
        }
        if (n > 0 && list.size() < n * 21 + 1) {
            this.openPage(this.getPage() - 1);
            return;
        }
        if (list.size() > 21) {
            list = list.subList(n * 21, Math.min(n * 21 + 21, list.size()));
        }
        GUILayout gUILayout = this.getMain().getLayoutHandler().getLayout("animations");
        CubeletType cubeletType = (CubeletType)this.getAttribute(Menu.AttrType.CUBELET_TYPE_ATTR);
        Inventory inventory = this.createInventory(45, "%cubelet_type% | Animations".replaceAll("%cubelet_type%", cubeletType.getId()));
        this.setInventory(inventory);
        ItemStack itemStack = new ItemBuilder(XMaterial.ARROW.parseItem()).setName(Utils.translate("&aBack to config")).toItemStack();
        itemStack = NBTEditor.set(itemStack, "back", "action");
        ItemStack itemStack2 = XMaterial.GRAY_STAINED_GLASS_PANE.parseItem();
        this.fillBorders(itemStack2);
        if (n > 0) {
            object = new ItemBuilder(XMaterial.ENDER_PEARL.parseMaterial(), 1).setName(Utils.translate("&aPrevious page")).toItemStack();
            object = NBTEditor.set(object, "previous", "action");
            inventory.setItem(18, (ItemStack)object);
        }
        if (this.getMain().getAnimationHandler().getAnimations().values().size() > (n + 1) * 21) {
            object = new ItemBuilder(XMaterial.ENDER_PEARL.parseMaterial(), 1).setName(Utils.translate("&aaNext page")).toItemStack();
            object = (ItemStack)NBTEditor.set(object, "next", "action");
            inventory.setItem(26, (ItemStack)object);
        }
        inventory.setItem(40, itemStack);
        for (AnimationSettings animationSettings : list) {
            inventory.addItem(new ItemStack[]{this.getAnimationItem(cubeletType, animationSettings.getId())});
        }
        object = this.getRandomAnimationItem(cubeletType, gUILayout);
        object = (ItemStack)NBTEditor.set(object, "animation", "action");
        inventory.setItem(38, (ItemStack)object);
        this.openInventory();
    }

    @Override
    public void OnMenuClick(InventoryClickEvent inventoryClickEvent) {
        inventoryClickEvent.setCancelled(true);
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        if (inventoryClickEvent.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        if (inventoryClickEvent.getClick() == ClickType.DOUBLE_CLICK) {
            return;
        }
        String string = NBTEditor.getString(inventoryClickEvent.getCurrentItem(), "action");
        if (inventoryClickEvent.getClick() == ClickType.DOUBLE_CLICK) {
            return;
        }
        if (string == null) {
            return;
        }
        Player player = this.getOwner();
        CubeletType cubeletType = (CubeletType)this.getAttribute(Menu.AttrType.CUBELET_TYPE_ATTR);
        switch (string) {
            case "previous": {
                this.previousPage();
                this.playSound(Menu.SoundType.CLICK);
                break;
            }
            case "next": {
                this.nextPage();
                this.playSound(Menu.SoundType.CLICK);
                break;
            }
            case "animation": {
                String string2 = NBTEditor.getString(inventoryClickEvent.getCurrentItem(), "status");
                String string3 = NBTEditor.getString(inventoryClickEvent.getCurrentItem(), "animation");
                if (!string2.equalsIgnoreCase("unlocked")) break;
                FileConfiguration fileConfiguration = this.getMain().getCubeletTypesHandler().getConfig(cubeletType.getId());
                fileConfiguration.set("type.animation", (Object)string3);
                cubeletType.setAnimation(string3);
                this.playSound(Menu.SoundType.CLICK);
                cubeletType.saveType();
                this.reloadMenu();
                break;
            }
            case "back": {
                TypeConfigMenu typeConfigMenu = new TypeConfigMenu(this.getMain(), player);
                typeConfigMenu.setAttribute(Menu.AttrType.CUSTOM_ID_ATTR, cubeletType.getId());
                typeConfigMenu.open();
            }
        }
    }

    @Override
    public void OnMenuClosed() {
    }

    private ItemStack getAnimationItem(CubeletType cubeletType, String string) {
        AnimationSettings animationSettings = this.getMain().getAnimationHandler().getAnimationSetting(string);
        ItemStack itemStack = animationSettings.getDisplayItem().clone();
        itemStack = !cubeletType.getAnimation().equalsIgnoreCase(string) ? this.getItem(animationSettings, "Unlocked", itemStack) : this.getItem(animationSettings, "Selected", itemStack);
        itemStack = NBTEditor.set(itemStack, string, "animation");
        itemStack = NBTEditor.set(itemStack, "animation", "action");
        return itemStack;
    }

    private ItemStack getItem(AnimationSettings animationSettings, String string, ItemStack itemStack) {
        String string2 = Utils.translate((string.equalsIgnoreCase("Selected") ? "&a" : "&c") + animationSettings.getDisplayName());
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        arrayList.add(Utils.translate("&eLeft-Click \u00bb " + (string.equalsIgnoreCase("Unlocked") ? "&a" : "&c") + "Enable animation "));
        ItemStack itemStack2 = string.equalsIgnoreCase("Selected") ? new ItemBuilder(itemStack).setName(string2).setLore(arrayList).addGlow().hideAttributes().toItemStack() : new ItemBuilder(itemStack).setName(string2).setLore(arrayList).hideAttributes().toItemStack();
        return NBTEditor.set(itemStack2, string.toLowerCase(), "status");
    }

    private ItemStack getRandomAnimationItem(CubeletType cubeletType, GUILayout gUILayout) {
        String string;
        ItemStack itemStack = new ItemBuilder(XMaterial.ENDER_PEARL.parseItem()).toItemStack();
        if (!cubeletType.getAnimation().equalsIgnoreCase("random")) {
            String string2 = gUILayout.getMessage("Items.RandomAnimation.NoSelected.Name");
            List<String> list = gUILayout.getMessageList("Items.RandomAnimation.NoSelected.Lore");
            itemStack = new ItemBuilder(itemStack).setName(string2).setLore(list).toItemStack();
            string = "Unlocked";
        } else {
            String string3 = gUILayout.getMessage("Items.RandomAnimation.Selected.Name");
            List<String> list = gUILayout.getMessageList("Items.RandomAnimation.Selected.Lore");
            itemStack = new ItemBuilder(itemStack).setName(string3).setLore(list).addGlow().toItemStack();
            string = "Selected";
        }
        itemStack = NBTEditor.set(itemStack, "random", "animation");
        itemStack = NBTEditor.set(itemStack, string.toLowerCase(), "status");
        return itemStack;
    }
}

