/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.menus.admin.rewards;

import com.cryptomorin.xseries.XMaterial;
import java.util.ArrayList;
import java.util.List;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.conversation.rarities.EditRarityConversation;
import me.davidml16.acubelets.conversation.rarities.RarityConversation;
import me.davidml16.acubelets.interfaces.RarityComparator;
import me.davidml16.acubelets.menus.admin.type.TypeConfigMenu;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.objects.Rarity;
import me.davidml16.acubelets.utils.ItemBuilder;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class RaritiesMenu
extends Menu {
    public RaritiesMenu(Main main, Player player) {
        super(main, player);
    }

    @Override
    public void OnPageOpened(int n) {
        int n2;
        String string = (String)this.getAttribute(Menu.AttrType.CUSTOM_ID_ATTR);
        List<Rarity> list = new ArrayList<Rarity>(this.getMain().getCubeletTypesHandler().getTypeBydId(string).getRarities().values());
        list.sort(new RarityComparator());
        if (n > 0 && list.size() < n * 21 + 1) {
            this.openPage(this.getPage() - 1);
            return;
        }
        Inventory inventory = this.createInventory(45, "%cubelet_type% | Rarities".replaceAll("%cubelet_type%", string));
        ItemStack itemStack = new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack();
        ItemStack itemStack2 = new ItemBuilder(XMaterial.SUNFLOWER.parseItem()).setName(Utils.translate("&aCreate new rarity")).toItemStack();
        ItemStack itemStack3 = new ItemBuilder(XMaterial.ARROW.parseItem()).setName(Utils.translate("&aBack to config")).toItemStack();
        this.fillBorders(itemStack);
        for (n2 = 10; n2 <= 16; ++n2) {
            inventory.setItem(n2, null);
        }
        for (n2 = 19; n2 <= 25; ++n2) {
            inventory.setItem(n2, null);
        }
        for (n2 = 28; n2 <= 34; ++n2) {
            inventory.setItem(n2, null);
        }
        if (n > 0) {
            inventory.setItem(18, new ItemBuilder(XMaterial.ENDER_PEARL.parseItem()).setName(Utils.translate("&aPrevious page")).toItemStack());
        } else {
            inventory.setItem(18, new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack());
        }
        if (list.size() > (n + 1) * 21) {
            inventory.setItem(26, new ItemBuilder(XMaterial.ENDER_PEARL.parseItem()).setName(Utils.translate("&aNext page")).toItemStack());
        } else {
            inventory.setItem(26, new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack());
        }
        if (list.size() > 21) {
            list = list.subList(n * 21, n * 21 + 21 > list.size() ? list.size() : n * 21 + 21);
        }
        if (list.size() > 0) {
            for (Rarity rarity : list) {
                inventory.addItem(new ItemStack[]{new ItemBuilder(XMaterial.ITEM_FRAME.parseItem()).setName(Utils.translate("&a" + rarity.getId())).setLore("", Utils.translate(" &7Name: &6" + rarity.getName() + " "), Utils.translate(" &7Chance: &6" + rarity.getChance() + "% "), Utils.translate(" &7Duplicate Points: &6" + rarity.getDuplicatePointsRange() + " "), "", Utils.translate("&eLeft-Click \u00bb &aRemove rarity "), Utils.translate("&eRight-Click \u00bb &aEdit rarity ")).toItemStack()});
            }
        } else {
            inventory.setItem(22, new ItemBuilder(XMaterial.RED_STAINED_GLASS_PANE.parseItem()).setName(Utils.translate("&cAny rarity created")).setLore("", Utils.translate(" &7You dont have any "), Utils.translate(" &7rarity created. "), "").toItemStack());
        }
        inventory.setItem(39, itemStack2);
        inventory.setItem(41, itemStack3);
        this.openInventory();
    }

    @Override
    public void OnMenuClick(InventoryClickEvent inventoryClickEvent) {
        inventoryClickEvent.setCancelled(true);
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        Player player = this.getOwner();
        String string = (String)this.getAttribute(Menu.AttrType.CUSTOM_ID_ATTR);
        int n = inventoryClickEvent.getRawSlot();
        CubeletType cubeletType = this.getMain().getCubeletTypesHandler().getTypeBydId(string);
        if (n == 18 && inventoryClickEvent.getCurrentItem().getType() == XMaterial.ENDER_PEARL.parseMaterial()) {
            this.previousPage();
            this.playSound(Menu.SoundType.CLICK);
        } else if (n == 26 && inventoryClickEvent.getCurrentItem().getType() == XMaterial.ENDER_PEARL.parseMaterial()) {
            this.nextPage();
            this.playSound(Menu.SoundType.CLICK);
        } else if (n == 39) {
            player.closeInventory();
            new RarityConversation(this.getMain()).getConversation(player, cubeletType).begin();
            this.playSound(Menu.SoundType.ANVIL_USE);
        } else if (n == 41) {
            TypeConfigMenu typeConfigMenu = new TypeConfigMenu(this.getMain(), player);
            typeConfigMenu.setAttribute(Menu.AttrType.CUSTOM_ID_ATTR, cubeletType.getId());
            typeConfigMenu.open();
        } else if (n >= 10 && n <= 16 || n >= 19 && n <= 25 || n >= 28 && n <= 34) {
            if (inventoryClickEvent.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            if (cubeletType.getAllRewards().size() == 0) {
                return;
            }
            String string2 = ChatColor.stripColor((String)inventoryClickEvent.getCurrentItem().getItemMeta().getDisplayName());
            Rarity rarity = cubeletType.getRarities().get(string2);
            if (inventoryClickEvent.getClick() == ClickType.LEFT || inventoryClickEvent.getClick() == ClickType.SHIFT_LEFT) {
                cubeletType.getRarities().remove(string2);
                player.sendMessage(Utils.translate(this.getMain().getLanguageHandler().getPrefix() + " &aYou removed rarity &e" + string2 + " &afrom rarities of cubelet type &e" + cubeletType.getId()));
                this.playSound(Menu.SoundType.CLICK);
                this.reloadMenu();
            } else if (inventoryClickEvent.getClick() == ClickType.RIGHT || inventoryClickEvent.getClick() == ClickType.SHIFT_RIGHT) {
                player.closeInventory();
                new EditRarityConversation(this.getMain()).getConversation(player, cubeletType, rarity).begin();
                this.playSound(Menu.SoundType.ANVIL_USE);
            }
        }
    }

    @Override
    public void OnMenuClosed() {
        String string = (String)this.getAttribute(Menu.AttrType.CUSTOM_ID_ATTR);
        this.getMain().getCubeletTypesHandler().getTypeBydId(string).saveType();
    }
}

