/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.tasks;

import java.util.Arrays;
import java.util.Collection;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.effects.MachineEffect;
import me.davidml16.acubelets.effects.MachineEffectModel;
import me.davidml16.acubelets.effects.SimpleParticle;
import me.davidml16.acubelets.enums.CubeletBoxState;
import me.davidml16.acubelets.objects.CubeletMachine;
import me.davidml16.acubelets.utils.LocationUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class MachineEffectsTask {
    private int id;
    private Main main;

    public MachineEffectsTask(Main main) {
        this.main = main;
    }

    public int getId() {
        return this.id;
    }

    public void start() {
        this.id = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.main, (Runnable)new Task(), 20L, 1L);
    }

    public void stop() {
        Bukkit.getServer().getScheduler().cancelTask(this.id);
    }

    class Task
    implements Runnable {
        Task() {
        }

        @Override
        public void run() {
            Collection<CubeletMachine> collection = MachineEffectsTask.this.main.getCubeletBoxHandler().getBoxes().values();
            collection.forEach(cubeletMachine -> {
                if (cubeletMachine.getBlockEffectModel() == MachineEffectModel.NONE) {
                    return;
                }
                if (cubeletMachine.getState() != CubeletBoxState.EMPTY) {
                    return;
                }
                SimpleParticle simpleParticle = cubeletMachine.getBlockEffectParticle();
                MachineEffect machineEffect = cubeletMachine.getBlockEffectModel().getEffect();
                Location location = cubeletMachine.getLocation().clone();
                World world = location.getWorld();
                int n = location.getBlockX() >> 4;
                int n2 = location.getBlockZ() >> 4;
                if (world == null || !world.isChunkLoaded(n, n2)) {
                    return;
                }
                Location location2 = LocationUtils.getCenter(location.clone());
                machineEffect.step(location2, simpleParticle);
            });
            Arrays.asList(MachineEffectModel.values()).forEach(machineEffectModel -> machineEffectModel.getEffect().addStep());
        }
    }
}

