/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.davidml16.acubelets.utils.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionUtils {
    @NotNull
    public static <T> List<List<T>> split(@NotNull List<T> list, int n) {
        ArrayList<List<T>> arrayList = new ArrayList<List<T>>();
        if (n <= 0) {
            return arrayList;
        }
        for (int i = 0; i < list.size(); i += n) {
            arrayList.add(list.subList(i, Math.min(i + n, list.size())));
        }
        return arrayList;
    }

    @NotNull
    public static <K, V extends Comparable<? super V>> Map<K, V> sortAscent(@NotNull Map<K, V> map) {
        return CollectionUtils.sort(map, Map.Entry.comparingByValue());
    }

    @NotNull
    public static <K, V extends Comparable<? super V>> Map<K, V> sortDescent(@NotNull Map<K, V> map) {
        return CollectionUtils.sort(map, Collections.reverseOrder(Map.Entry.comparingByValue()));
    }

    @NotNull
    public static <K, V extends Comparable<? super V>> Map<K, V> sort(@NotNull Map<K, V> map, @NotNull Comparator<Map.Entry<K, V>> comparator) {
        return new LinkedList<Map.Entry<K, V>>(map.entrySet()).stream().sorted(comparator).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (comparable, comparable2) -> comparable2, LinkedHashMap::new));
    }

    @NotNull
    public static <T extends Enum<T>> T next(@NotNull Enum<T> enum_) {
        return CollectionUtils.shifted(enum_, 1);
    }

    @NotNull
    public static <T extends Enum<T>> T next(@NotNull Enum<T> enum_, @NotNull Predicate<T> predicate) {
        return CollectionUtils.shifted(enum_, 1, predicate);
    }

    @NotNull
    public static <T extends Enum<T>> T previous(@NotNull Enum<T> enum_) {
        return CollectionUtils.shifted(enum_, -1);
    }

    @NotNull
    public static <T extends Enum<T>> T previous(@NotNull Enum<T> enum_, @NotNull Predicate<T> predicate) {
        return CollectionUtils.shifted(enum_, -1, predicate);
    }

    @NotNull
    public static <T extends Enum<T>> T shifted(@NotNull Enum<T> enum_, int n) {
        return CollectionUtils.shifted(enum_, n, null);
    }

    @NotNull
    private static <T extends Enum<T>> T shifted(@NotNull Enum<T> enum_, int n, @Nullable Predicate<T> predicate) {
        Enum[] enumArray = (Enum[])enum_.getDeclaringClass().getEnumConstants();
        return (T)CollectionUtils.shifted((Enum[])enumArray, enum_, (int)n, predicate);
    }

    @NotNull
    private static <T extends Enum<T>> T shifted(T[] TArray, @NotNull Enum<T> enum_, int n, @Nullable Predicate<T> predicate) {
        if (predicate != null) {
            Enum enum_3 = (Enum)enum_.getDeclaringClass().cast(enum_);
            ArrayList<T> arrayList = new ArrayList<T>(Arrays.asList(TArray));
            arrayList.removeIf(enum_2 -> !predicate.test(enum_2) && enum_2 != enum_3);
            int n2 = arrayList.indexOf(enum_3);
            if (n2 < 0 | arrayList.isEmpty()) {
                return (T)enum_3;
            }
            return (T)((Enum)CollectionUtils.shifted(arrayList, n2, n));
        }
        return (T)((Enum)CollectionUtils.shifted(TArray, enum_.ordinal(), n));
    }

    @NotNull
    public static <T> T shifted(T[] TArray, int n, int n2) {
        int n3 = n + n2;
        return TArray[n3 >= TArray.length || n3 < 0 ? 0 : n3];
    }

    @NotNull
    public static <T> T shifted(@NotNull List<T> list, int n, int n2) {
        int n3 = n + n2;
        return list.get(n3 >= list.size() || n3 < 0 ? 0 : n3);
    }

    @Deprecated
    @Nullable
    public static <T extends Enum<T>> T getEnum(@NotNull String string, @NotNull Class<T> clazz) {
        return (T)((Enum)StringUtils.getEnum(string, clazz).orElse(null));
    }
}

