/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.utils;

public final class MathL {
    private static final int SIN_BITS;
    private static final int SIN_MASK;
    private static final int SIN_COUNT;
    private static final double radFull;
    private static final double radToIndex;
    private static final double degFull;
    private static final double degToIndex;
    private static final double[] sin;
    private static final double[] cos;

    public static double sin(double d) {
        return sin[(int)(d * radToIndex) & SIN_MASK];
    }

    public static double cos(double d) {
        return cos[(int)(d * radToIndex) & SIN_MASK];
    }

    static {
        int n;
        SIN_BITS = 12;
        SIN_MASK = ~(-1 << SIN_BITS);
        SIN_COUNT = SIN_MASK + 1;
        radFull = Math.PI * 2;
        degFull = 360.0;
        radToIndex = (double)SIN_COUNT / radFull;
        degToIndex = (double)SIN_COUNT / degFull;
        sin = new double[SIN_COUNT];
        cos = new double[SIN_COUNT];
        for (n = 0; n < SIN_COUNT; ++n) {
            MathL.sin[n] = Math.sin((double)(((float)n + 0.5f) / (float)SIN_COUNT) * radFull);
            MathL.cos[n] = Math.cos((double)(((float)n + 0.5f) / (float)SIN_COUNT) * radFull);
        }
        for (n = 0; n < 360; n += 90) {
            MathL.sin[(int)((double)n * MathL.degToIndex) & MathL.SIN_MASK] = Math.sin((double)n * Math.PI / 180.0);
            MathL.cos[(int)((double)n * MathL.degToIndex) & MathL.SIN_MASK] = Math.cos((double)n * Math.PI / 180.0);
        }
    }
}

