/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.jsoup.SerializationException;
import org.jsoup.helper.Validate;
import org.jsoup.internal.Normalizer;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.parser.ParseSettings;

public class Attributes
implements Iterable<Attribute>,
Cloneable {
    protected static final String dataPrefix = "data-";
    static final char InternalPrefix = '/';
    private static final int InitialCapacity = 3;
    private static final int GrowthFactor = 2;
    static final int NotFound = -1;
    private static final String EmptyString = "";
    private int size = 0;
    String[] keys = new String[3];
    Object[] vals = new Object[3];

    private void checkCapacity(int n) {
        int n2;
        Validate.isTrue(n >= this.size);
        int n3 = this.keys.length;
        if (n3 >= n) {
            return;
        }
        int n4 = n2 = n3 >= 3 ? this.size * 2 : 3;
        if (n > n2) {
            n2 = n;
        }
        this.keys = Arrays.copyOf(this.keys, n2);
        this.vals = Arrays.copyOf(this.vals, n2);
    }

    int indexOfKey(String string) {
        Validate.notNull(string);
        for (int i = 0; i < this.size; ++i) {
            if (!string.equals(this.keys[i])) continue;
            return i;
        }
        return -1;
    }

    private int indexOfKeyIgnoreCase(String string) {
        Validate.notNull(string);
        for (int i = 0; i < this.size; ++i) {
            if (!string.equalsIgnoreCase(this.keys[i])) continue;
            return i;
        }
        return -1;
    }

    static String checkNotNull(@Nullable Object object) {
        return object == null ? EmptyString : (String)object;
    }

    public String get(String string) {
        int n = this.indexOfKey(string);
        return n == -1 ? EmptyString : Attributes.checkNotNull(this.vals[n]);
    }

    public String getIgnoreCase(String string) {
        int n = this.indexOfKeyIgnoreCase(string);
        return n == -1 ? EmptyString : Attributes.checkNotNull(this.vals[n]);
    }

    @Nullable
    Object getUserData(String string) {
        int n;
        Validate.notNull(string);
        if (!this.isInternalKey(string)) {
            string = Attributes.internalKey(string);
        }
        return (n = this.indexOfKeyIgnoreCase(string)) == -1 ? null : this.vals[n];
    }

    public Attributes add(String string, @Nullable String string2) {
        this.addObject(string, string2);
        return this;
    }

    private void addObject(String string, @Nullable Object object) {
        this.checkCapacity(this.size + 1);
        this.keys[this.size] = string;
        this.vals[this.size] = object;
        ++this.size;
    }

    public Attributes put(String string, @Nullable String string2) {
        Validate.notNull(string);
        int n = this.indexOfKey(string);
        if (n != -1) {
            this.vals[n] = string2;
        } else {
            this.add(string, string2);
        }
        return this;
    }

    Attributes putUserData(String string, Object object) {
        Validate.notNull(string);
        if (!this.isInternalKey(string)) {
            string = Attributes.internalKey(string);
        }
        Validate.notNull(object);
        int n = this.indexOfKey(string);
        if (n != -1) {
            this.vals[n] = object;
        } else {
            this.addObject(string, object);
        }
        return this;
    }

    void putIgnoreCase(String string, @Nullable String string2) {
        int n = this.indexOfKeyIgnoreCase(string);
        if (n != -1) {
            this.vals[n] = string2;
            if (!this.keys[n].equals(string)) {
                this.keys[n] = string;
            }
        } else {
            this.add(string, string2);
        }
    }

    public Attributes put(String string, boolean bl) {
        if (bl) {
            this.putIgnoreCase(string, null);
        } else {
            this.remove(string);
        }
        return this;
    }

    public Attributes put(Attribute attribute) {
        Validate.notNull(attribute);
        this.put(attribute.getKey(), attribute.getValue());
        attribute.parent = this;
        return this;
    }

    private void remove(int n) {
        Validate.isFalse(n >= this.size);
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.keys, n + 1, this.keys, n, n2);
            System.arraycopy(this.vals, n + 1, this.vals, n, n2);
        }
        --this.size;
        this.keys[this.size] = null;
        this.vals[this.size] = null;
    }

    public void remove(String string) {
        int n = this.indexOfKey(string);
        if (n != -1) {
            this.remove(n);
        }
    }

    public void removeIgnoreCase(String string) {
        int n = this.indexOfKeyIgnoreCase(string);
        if (n != -1) {
            this.remove(n);
        }
    }

    public boolean hasKey(String string) {
        return this.indexOfKey(string) != -1;
    }

    public boolean hasKeyIgnoreCase(String string) {
        return this.indexOfKeyIgnoreCase(string) != -1;
    }

    public boolean hasDeclaredValueForKey(String string) {
        int n = this.indexOfKey(string);
        return n != -1 && this.vals[n] != null;
    }

    public boolean hasDeclaredValueForKeyIgnoreCase(String string) {
        int n = this.indexOfKeyIgnoreCase(string);
        return n != -1 && this.vals[n] != null;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void addAll(Attributes attributes) {
        if (attributes.size() == 0) {
            return;
        }
        this.checkCapacity(this.size + attributes.size);
        boolean bl = this.size != 0;
        for (Attribute attribute : attributes) {
            if (bl) {
                this.put(attribute);
                continue;
            }
            this.add(attribute.getKey(), attribute.getValue());
        }
    }

    @Override
    public Iterator<Attribute> iterator() {
        return new Iterator<Attribute>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                while (this.i < Attributes.this.size && Attributes.this.isInternalKey(Attributes.this.keys[this.i])) {
                    ++this.i;
                }
                return this.i < Attributes.this.size;
            }

            @Override
            public Attribute next() {
                Attribute attribute = new Attribute(Attributes.this.keys[this.i], (String)Attributes.this.vals[this.i], Attributes.this);
                ++this.i;
                return attribute;
            }

            @Override
            public void remove() {
                Attributes.this.remove(--this.i);
            }
        };
    }

    public List<Attribute> asList() {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(this.size);
        for (int i = 0; i < this.size; ++i) {
            if (this.isInternalKey(this.keys[i])) continue;
            Attribute attribute = new Attribute(this.keys[i], (String)this.vals[i], this);
            arrayList.add(attribute);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Map<String, String> dataset() {
        return new Dataset(this);
    }

    public String html() {
        StringBuilder stringBuilder = StringUtil.borrowBuilder();
        try {
            this.html(stringBuilder, new Document(EmptyString).outputSettings());
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
        return StringUtil.releaseBuilder(stringBuilder);
    }

    final void html(Appendable appendable, Document.OutputSettings outputSettings) {
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            String string;
            if (this.isInternalKey(this.keys[i]) || (string = Attribute.getValidKey(this.keys[i], outputSettings.syntax())) == null) continue;
            Attribute.htmlNoValidate(string, (String)this.vals[i], appendable.append(' '), outputSettings);
        }
    }

    public String toString() {
        return this.html();
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Attributes attributes = (Attributes)object;
        if (this.size != attributes.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            String string = this.keys[i];
            int n = attributes.indexOfKey(string);
            if (n == -1) {
                return false;
            }
            Object object2 = this.vals[i];
            Object object3 = attributes.vals[n];
            if (!(object2 == null ? object3 != null : !object2.equals(object3))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.size;
        n = 31 * n + Arrays.hashCode(this.keys);
        n = 31 * n + Arrays.hashCode(this.vals);
        return n;
    }

    public Attributes clone() {
        Attributes attributes;
        try {
            attributes = (Attributes)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
        attributes.size = this.size;
        attributes.keys = Arrays.copyOf(this.keys, this.size);
        attributes.vals = Arrays.copyOf(this.vals, this.size);
        return attributes;
    }

    public void normalize() {
        for (int i = 0; i < this.size; ++i) {
            this.keys[i] = Normalizer.lowerCase(this.keys[i]);
        }
    }

    public int deduplicate(ParseSettings parseSettings) {
        if (this.isEmpty()) {
            return 0;
        }
        boolean bl = parseSettings.preserveAttributeCase();
        int n = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            for (int j = i + 1; j < this.keys.length && this.keys[j] != null; ++j) {
                if ((!bl || !this.keys[i].equals(this.keys[j])) && (bl || !this.keys[i].equalsIgnoreCase(this.keys[j]))) continue;
                ++n;
                this.remove(j);
                --j;
            }
        }
        return n;
    }

    private static String dataKey(String string) {
        return dataPrefix + string;
    }

    static String internalKey(String string) {
        return '/' + string;
    }

    private boolean isInternalKey(String string) {
        return string != null && string.length() > 1 && string.charAt(0) == '/';
    }

    private static class Dataset
    extends AbstractMap<String, String> {
        private final Attributes attributes;

        private Dataset(Attributes attributes) {
            this.attributes = attributes;
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return new EntrySet();
        }

        @Override
        public String put(String string, String string2) {
            String string3 = Attributes.dataKey(string);
            String string4 = this.attributes.hasKey(string3) ? this.attributes.get(string3) : null;
            this.attributes.put(string3, string2);
            return string4;
        }

        private class EntrySet
        extends AbstractSet<Map.Entry<String, String>> {
            private EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                return new DatasetIterator();
            }

            @Override
            public int size() {
                int n = 0;
                DatasetIterator datasetIterator = new DatasetIterator();
                while (datasetIterator.hasNext()) {
                    ++n;
                }
                return n;
            }
        }

        private class DatasetIterator
        implements Iterator<Map.Entry<String, String>> {
            private Iterator<Attribute> attrIter;
            private Attribute attr;

            private DatasetIterator() {
                this.attrIter = Dataset.this.attributes.iterator();
            }

            @Override
            public boolean hasNext() {
                while (this.attrIter.hasNext()) {
                    this.attr = this.attrIter.next();
                    if (!this.attr.isDataAttribute()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Map.Entry<String, String> next() {
                return new Attribute(this.attr.getKey().substring(Attributes.dataPrefix.length()), this.attr.getValue());
            }

            @Override
            public void remove() {
                Dataset.this.attributes.remove(this.attr.getKey());
            }
        }
    }
}

