/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import javax.annotation.Nullable;
import org.jsoup.internal.Normalizer;
import org.jsoup.nodes.Attributes;

public class ParseSettings {
    public static final ParseSettings htmlDefault = new ParseSettings(false, false);
    public static final ParseSettings preserveCase = new ParseSettings(true, true);
    private final boolean preserveTagCase;
    private final boolean preserveAttributeCase;

    public boolean preserveTagCase() {
        return this.preserveTagCase;
    }

    public boolean preserveAttributeCase() {
        return this.preserveAttributeCase;
    }

    public ParseSettings(boolean bl, boolean bl2) {
        this.preserveTagCase = bl;
        this.preserveAttributeCase = bl2;
    }

    ParseSettings(ParseSettings parseSettings) {
        this(parseSettings.preserveTagCase, parseSettings.preserveAttributeCase);
    }

    public String normalizeTag(String string) {
        string = string.trim();
        if (!this.preserveTagCase) {
            string = Normalizer.lowerCase(string);
        }
        return string;
    }

    public String normalizeAttribute(String string) {
        string = string.trim();
        if (!this.preserveAttributeCase) {
            string = Normalizer.lowerCase(string);
        }
        return string;
    }

    @Nullable
    Attributes normalizeAttributes(@Nullable Attributes attributes) {
        if (attributes != null && !this.preserveAttributeCase) {
            attributes.normalize();
        }
        return attributes;
    }

    static String normalName(String string) {
        return Normalizer.lowerCase(string.trim());
    }
}

