/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.internal;

import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class TagInternals {
    private static final Pattern TAG_NAME_PATTERN = Pattern.compile("[!?#]?[a-z0-9_-]*");

    private TagInternals() {
    }

    public static void assertValidTagName(@NotNull String string) {
        if (!TAG_NAME_PATTERN.matcher(Objects.requireNonNull(string)).matches()) {
            throw new IllegalArgumentException("Tag name must match pattern " + TAG_NAME_PATTERN.pattern() + ", was " + string);
        }
    }

    public static boolean sanitizeAndCheckValidTagName(@NotNull String string) {
        return TAG_NAME_PATTERN.matcher(Objects.requireNonNull(string).toLowerCase(Locale.ROOT)).matches();
    }

    public static void sanitizeAndAssertValidTagName(@NotNull String string) {
        TagInternals.assertValidTagName(Objects.requireNonNull(string).toLowerCase(Locale.ROOT));
    }
}

