/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.util;

import java.util.Iterator;
import java.util.Optional;
import java.util.ServiceLoader;
import net.kyori.adventure.internal.properties.AdventureProperties;
import net.kyori.adventure.util.Services0;
import org.jetbrains.annotations.NotNull;

public final class Services {
    private static final boolean SERVICE_LOAD_FAILURES_ARE_FATAL = Boolean.TRUE.equals(AdventureProperties.SERVICE_LOAD_FAILURES_ARE_FATAL.value());

    private Services() {
    }

    @NotNull
    public static <P> Optional<P> service(@NotNull Class<P> clazz) {
        ServiceLoader<P> serviceLoader = Services0.loader(clazz);
        Iterator<P> iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            P p;
            try {
                p = iterator.next();
            }
            catch (Throwable throwable) {
                if (!SERVICE_LOAD_FAILURES_ARE_FATAL) continue;
                throw new IllegalStateException("Encountered an exception loading service " + clazz, throwable);
            }
            if (iterator.hasNext()) {
                throw new IllegalStateException("Expected to find one service " + clazz + ", found multiple");
            }
            return Optional.of(p);
        }
        return Optional.empty();
    }
}

