/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.commands.commands.leavequeue;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.api.commands.ISubCommand;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.players.QueuePlayer;
import us.ajg0702.queue.api.queues.QueueServer;
import us.ajg0702.queue.commands.BaseCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.Messages;

public class LeaveCommand
extends BaseCommand {
    private final QueueMain main;

    public LeaveCommand(QueueMain queueMain) {
        this.main = queueMain;
    }

    @Override
    public String getName() {
        return "leavequeue";
    }

    @Override
    public ImmutableList<String> getAliases() {
        return ImmutableList.of((Object)"leaveq");
    }

    @Override
    public ImmutableList<ISubCommand> getSubCommands() {
        return ImmutableList.of();
    }

    @Override
    public String getPermission() {
        return null;
    }

    @Override
    public Messages getMessages() {
        return this.main.getMessages();
    }

    @Override
    public void execute(ICommandSender iCommandSender, String[] stringArray) {
        if (!iCommandSender.isPlayer()) {
            iCommandSender.sendMessage(this.getMessages().getComponent("errors.player-only", new String[0]));
            return;
        }
        AdaptedPlayer adaptedPlayer = this.main.getPlatformMethods().senderToPlayer(iCommandSender);
        ImmutableList<QueueServer> immutableList = this.main.getQueueManager().getPlayerQueues(adaptedPlayer);
        if (immutableList.size() == 0) {
            iCommandSender.sendMessage(this.getMessages().getComponent("commands.leave.no-queues", new String[0]));
            return;
        }
        if (immutableList.size() == 1) {
            ((QueueServer)immutableList.get(0)).removePlayer(adaptedPlayer);
            iCommandSender.sendMessage(this.getMessages().getComponent("commands.leave-queue", "SERVER:" + ((QueueServer)immutableList.get(0)).getAlias()));
            return;
        }
        if (stringArray.length <= 0) {
            iCommandSender.sendMessage(this.getMessages().getComponent("commands.leave.more-args", "QUEUES:" + this.getQueueList((List<QueueServer>)immutableList)));
            return;
        }
        String string = stringArray[0];
        QueueServer queueServer = this.main.getQueueManager().findServer(string);
        if (queueServer == null) {
            iCommandSender.sendMessage(this.getMessages().getComponent("commands.leave.not-queued", "QUEUES:" + this.getQueueList((List<QueueServer>)immutableList)));
            return;
        }
        QueuePlayer queuePlayer = queueServer.findPlayer(adaptedPlayer);
        if (queuePlayer == null) {
            iCommandSender.sendMessage(this.getMessages().getComponent("commands.leave.not-queued", "QUEUES:" + this.getQueueList((List<QueueServer>)immutableList)));
            return;
        }
        queueServer.removePlayer(queuePlayer);
        iCommandSender.sendMessage(this.getMessages().getComponent("commands.leave-queue", "SERVER:" + queueServer.getAlias()));
    }

    private String getQueueList(List<QueueServer> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (QueueServer queueServer : list) {
            stringBuilder.append(this.getMessages().getString("commands.leave.queues-list-format", new String[0]).replaceAll("\\{NAME}", queueServer.getName()));
        }
        if (stringBuilder.length() > 2) {
            stringBuilder = new StringBuilder(stringBuilder.substring(0, stringBuilder.length() - 2));
        }
        return stringBuilder.toString();
    }

    @Override
    public List<String> autoComplete(ICommandSender iCommandSender, String[] stringArray) {
        ImmutableList<QueuePlayer> immutableList = this.main.getQueueManager().findPlayerInQueues(this.main.getPlatformMethods().senderToPlayer(iCommandSender));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (QueuePlayer queuePlayer : immutableList) {
            arrayList.add(queuePlayer.getQueueServer().getName());
        }
        return arrayList;
    }
}

