/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.commands.commands.listqueues;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.api.commands.ISubCommand;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.queues.QueueServer;
import us.ajg0702.queue.commands.BaseCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.Messages;

public class ListCommand
extends BaseCommand {
    private final QueueMain main;

    public ListCommand(QueueMain queueMain) {
        this.main = queueMain;
    }

    @Override
    public String getName() {
        return "listqueues";
    }

    @Override
    public ImmutableList<String> getAliases() {
        return ImmutableList.of((Object)"listq");
    }

    @Override
    public ImmutableList<ISubCommand> getSubCommands() {
        return ImmutableList.builder().build();
    }

    @Override
    public String getPermission() {
        return "ajqueue.listqueues";
    }

    @Override
    public Messages getMessages() {
        return this.main.getMessages();
    }

    @Override
    public void execute(ICommandSender iCommandSender, String[] stringArray) {
        if (!this.checkPermission(iCommandSender)) {
            return;
        }
        AdaptedPlayer adaptedPlayer = null;
        if (iCommandSender.isPlayer()) {
            adaptedPlayer = this.main.getPlatformMethods().senderToPlayer(iCommandSender);
        }
        Component component = this.main.getMessages().getComponent("commands.listqueues.header", new String[0]);
        for (QueueServer queueServer : this.main.getQueueManager().getServers()) {
            String string = "&a";
            if (!queueServer.isOnline()) {
                string = "&c";
            } else if (!queueServer.isJoinable(adaptedPlayer)) {
                string = "&e";
            }
            component = component.append(Component.text("\n"));
            component = component.append(this.main.getMessages().getComponent("commands.listqueues.format", "COLOR:" + Messages.color(string), "NAME:" + queueServer.getAlias(), "COUNT:" + queueServer.getQueue().size(), "STATUS:" + Messages.color(this.main.getMessages().getRawString("placeholders.status." + queueServer.getStatus(adaptedPlayer), new String[0]))));
        }
        iCommandSender.sendMessage(component);
    }

    @Override
    public List<String> autoComplete(ICommandSender iCommandSender, String[] stringArray) {
        return new ArrayList<String>();
    }
}

