/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.commands.commands.manage;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.api.commands.ISubCommand;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.commands.SubCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.Messages;

public class PauseQueueServer
extends SubCommand {
    public static final List<AdaptedPlayer> pausedPlayers = new CopyOnWriteArrayList<AdaptedPlayer>();
    final QueueMain main;

    public PauseQueueServer(QueueMain queueMain) {
        this.main = queueMain;
    }

    @Override
    public String getName() {
        return "pausequeueserver";
    }

    @Override
    public ImmutableList<String> getAliases() {
        return ImmutableList.of((Object)"pauseqs");
    }

    @Override
    public ImmutableList<ISubCommand> getSubCommands() {
        return ImmutableList.of();
    }

    @Override
    public String getPermission() {
        return "ajqueue.manage.pausequeueserver";
    }

    @Override
    public boolean showInTabComplete() {
        return true;
    }

    @Override
    public Messages getMessages() {
        return this.main.getMessages();
    }

    @Override
    public void execute(ICommandSender iCommandSender, String[] stringArray) {
        if (!this.checkPermission(iCommandSender)) {
            return;
        }
        if (!iCommandSender.isPlayer()) {
            iCommandSender.sendMessage(this.getMessages().getComponent("errors.player-only", new String[0]));
            return;
        }
        AdaptedPlayer adaptedPlayer = this.main.getPlatformMethods().getPlayer(iCommandSender.getUniqueId());
        if (pausedPlayers.contains(adaptedPlayer)) {
            pausedPlayers.remove(adaptedPlayer);
            iCommandSender.sendMessage(this.getMessages().getComponent("commands.pausequeueserver.unpaused", new String[0]));
            return;
        }
        pausedPlayers.add(adaptedPlayer);
        iCommandSender.sendMessage(this.getMessages().getComponent("commands.pausequeueserver.paused", new String[0]));
    }

    @Override
    public List<String> autoComplete(ICommandSender iCommandSender, String[] stringArray) {
        return Collections.emptyList();
    }
}

