/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.commands.commands.manage;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.commands.SubCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.Messages;

public class Send
extends SubCommand {
    final QueueMain main;

    public Send(QueueMain queueMain) {
        this.main = queueMain;
    }

    @Override
    public String getName() {
        return "send";
    }

    @Override
    public ImmutableList<String> getAliases() {
        return ImmutableList.of();
    }

    @Override
    public String getPermission() {
        return "ajqueue.manage.send";
    }

    @Override
    public Messages getMessages() {
        return this.main.getMessages();
    }

    @Override
    public void execute(ICommandSender iCommandSender, String[] stringArray) {
        if (!this.checkPermission(iCommandSender)) {
            return;
        }
        if (stringArray.length < 2) {
            iCommandSender.sendMessage(this.getMessages().getComponent("commands.send.usage", new String[0]));
            return;
        }
        if (this.main.getQueueManager().findServer(stringArray[1]) == null) {
            iCommandSender.sendMessage(this.getMessages().getComponent("errors.server-not-exist", "SERVER:" + stringArray[1]));
            return;
        }
        List<String> list = this.main.getPlatformMethods().getPlayerNames(true);
        if (list.contains(stringArray[0].toLowerCase())) {
            AdaptedPlayer adaptedPlayer = this.main.getPlatformMethods().getPlayer(stringArray[0]);
            if (adaptedPlayer == null) {
                iCommandSender.sendMessage(Component.text("player not found (even though it was in playerNames)"));
                return;
            }
            if (adaptedPlayer.getName() == null) {
                iCommandSender.sendMessage(Component.text("name null"));
            }
            this.main.getQueueManager().addToQueue(adaptedPlayer, stringArray[1]);
            iCommandSender.sendMessage(this.getMessages().getComponent("send", "PLAYER:" + adaptedPlayer.getName(), "SERVER:" + stringArray[1]));
        } else if (this.main.getQueueManager().getServerNames().contains((Object)stringArray[0])) {
            AdaptedServer adaptedServer = this.main.getPlatformMethods().getServer(stringArray[0]);
            if (adaptedServer == null) {
                iCommandSender.sendMessage(this.getMessages().getComponent("errors.server-not-exist", "SERVER:" + stringArray[0]));
                return;
            }
            ArrayList<AdaptedPlayer> arrayList = new ArrayList<AdaptedPlayer>(adaptedServer.getPlayers());
            for (AdaptedPlayer adaptedPlayer : arrayList) {
                this.main.getQueueManager().addToQueue(adaptedPlayer, stringArray[1]);
            }
            iCommandSender.sendMessage(this.getMessages().getComponent("send", "PLAYER:" + stringArray[0], "SERVER:" + stringArray[1]));
        } else {
            iCommandSender.sendMessage(this.getMessages().getComponent("commands.send.player-not-found", new String[0]));
        }
    }

    @Override
    public List<String> autoComplete(ICommandSender iCommandSender, String[] stringArray) {
        if (stringArray.length == 1) {
            ArrayList<String> arrayList = new ArrayList<String>(this.main.getPlatformMethods().getServerNames());
            arrayList.addAll(this.main.getPlatformMethods().getPlayerNames(false));
            return arrayList;
        }
        if (stringArray.length == 2) {
            return this.main.getQueueManager().getServerNames();
        }
        return new ArrayList<String>();
    }
}

