/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.commands.commands.manage;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.commands.SubCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.Messages;
import us.ajg0702.queue.libs.utils.common.Updater;

public class Update
extends SubCommand {
    final QueueMain main;

    public Update(QueueMain queueMain) {
        this.main = queueMain;
    }

    @Override
    public String getName() {
        return "update";
    }

    @Override
    public ImmutableList<String> getAliases() {
        return ImmutableList.of();
    }

    @Override
    public String getPermission() {
        return "ajqueue.manage.update";
    }

    @Override
    public Messages getMessages() {
        return this.main.getMessages();
    }

    @Override
    public void execute(ICommandSender iCommandSender, String[] stringArray) {
        if (!this.checkPermission(iCommandSender)) {
            return;
        }
        Updater updater = this.main.getUpdater();
        if (updater.isAlreadyDownloaded()) {
            iCommandSender.sendMessage(this.getMessages().getComponent("updater.already-downloaded", new String[0]));
            return;
        }
        if (!updater.isUpdateAvailable()) {
            iCommandSender.sendMessage(this.getMessages().getComponent("updater.no-update", new String[0]));
            return;
        }
        if (updater.downloadUpdate()) {
            iCommandSender.sendMessage(this.getMessages().getComponent("updater.success", new String[0]));
        } else {
            iCommandSender.sendMessage(this.getMessages().getComponent("updater.fail", new String[0]));
        }
    }

    @Override
    public List<String> autoComplete(ICommandSender iCommandSender, String[] stringArray) {
        return new ArrayList<String>();
    }
}

