/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.commands.commands.manage.debug;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.commands.SubCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.Messages;

public class Whitelist
extends SubCommand {
    final QueueMain main;

    public Whitelist(QueueMain queueMain) {
        this.main = queueMain;
    }

    @Override
    public String getName() {
        return "whitelist";
    }

    @Override
    public ImmutableList<String> getAliases() {
        return ImmutableList.of();
    }

    @Override
    public String getPermission() {
        return null;
    }

    @Override
    public boolean showInTabComplete() {
        return false;
    }

    @Override
    public Messages getMessages() {
        return this.main.getMessages();
    }

    @Override
    public void execute(ICommandSender iCommandSender, String[] stringArray) {
        if (!this.checkPermission(iCommandSender)) {
            return;
        }
        if (stringArray.length < 1) {
            iCommandSender.sendMessage(this.main.getMessages().toComponent("<red>Not enough args!"));
            return;
        }
        AdaptedServer adaptedServer = this.main.getPlatformMethods().getServer(stringArray[0]);
        if (adaptedServer == null) {
            iCommandSender.sendMessage(this.main.getMessages().toComponent("<red>Server not found"));
            return;
        }
        iCommandSender.sendMessage(this.main.getMessages().toComponent("<green>Yours: " + this.main.getPlatformMethods().senderToPlayer(iCommandSender).getUniqueId().toString()));
        adaptedServer.getWhitelistedPlayers().forEach(uUID -> iCommandSender.sendMessage(this.main.getMessages().toComponent("<yellow>" + uUID)));
    }

    @Override
    public List<String> autoComplete(ICommandSender iCommandSender, String[] stringArray) {
        return new ArrayList<String>();
    }
}

