/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.common.communication;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Map;
import us.ajg0702.queue.api.communication.ComResponse;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.common.communication.MessageHandler;
import us.ajg0702.queue.common.communication.handlers.AckHandler;
import us.ajg0702.queue.common.communication.handlers.EstimatedTimeHandler;
import us.ajg0702.queue.common.communication.handlers.InQueueHandler;
import us.ajg0702.queue.common.communication.handlers.LeaveQueueHandler;
import us.ajg0702.queue.common.communication.handlers.MassQueueHandler;
import us.ajg0702.queue.common.communication.handlers.PlayerStatusHandler;
import us.ajg0702.queue.common.communication.handlers.PositionHandler;
import us.ajg0702.queue.common.communication.handlers.PositionOfHandler;
import us.ajg0702.queue.common.communication.handlers.QueueHandler;
import us.ajg0702.queue.common.communication.handlers.QueueNameHandler;
import us.ajg0702.queue.common.communication.handlers.QueuedForHandler;
import us.ajg0702.queue.common.communication.handlers.ServerQueueHandler;
import us.ajg0702.queue.common.communication.handlers.StatusHandler;
import us.ajg0702.queue.common.utils.MapBuilder;

public class CommunicationManager {
    private final QueueMain main;
    Map<String, MessageHandler> handlers;

    public CommunicationManager(QueueMain queueMain) {
        this.main = queueMain;
        this.handlers = new MapBuilder<String, MessageHandler>("ack", new AckHandler(queueMain), "queue", new QueueHandler(queueMain), "massqueue", new MassQueueHandler(queueMain), "leavequeue", new LeaveQueueHandler(queueMain), "queuename", new QueueNameHandler(queueMain), "position", new PositionHandler(queueMain), "positionof", new PositionOfHandler(queueMain), "estimated_time", new EstimatedTimeHandler(queueMain), "inqueue", new InQueueHandler(queueMain), "queuedfor", new QueuedForHandler(queueMain), "status", new StatusHandler(queueMain), "playerstatus", new PlayerStatusHandler(queueMain), "serverqueue", new ServerQueueHandler(queueMain));
    }

    public void handle(AdaptedPlayer adaptedPlayer, byte[] byArray) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        String string = dataInputStream.readUTF();
        MessageHandler messageHandler = this.handlers.get(string);
        if (messageHandler == null) {
            this.main.getLogger().warn("Invalid sub-channel " + string);
            return;
        }
        ComResponse comResponse = messageHandler.handleMessage(adaptedPlayer, dataInputStream.readUTF());
        if (comResponse == null) {
            return;
        }
        if (!adaptedPlayer.isConnected()) {
            return;
        }
        this.main.getPlatformMethods().sendPluginMessage(adaptedPlayer, this.s(comResponse.getFrom()), this.s(comResponse.getIdentifier()), this.s(comResponse.getResponse()), this.s(comResponse.getNoneMessage()));
    }

    private String s(String string) {
        return string + "";
    }
}

