/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.geantyref;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import us.ajg0702.queue.libs.geantyref.AnnotatedArrayTypeImpl;
import us.ajg0702.queue.libs.geantyref.AnnotatedParameterizedTypeImpl;
import us.ajg0702.queue.libs.geantyref.AnnotationInvocationHandler;
import us.ajg0702.queue.libs.geantyref.GenericArrayTypeImpl;
import us.ajg0702.queue.libs.geantyref.GenericTypeReflector;
import us.ajg0702.queue.libs.geantyref.ParameterizedTypeImpl;
import us.ajg0702.queue.libs.geantyref.TypeArgumentNotInBoundException;
import us.ajg0702.queue.libs.geantyref.VarMap;
import us.ajg0702.queue.libs.geantyref.WildcardTypeImpl;

public class TypeFactory {
    private static final WildcardType UNBOUND_WILDCARD = new WildcardTypeImpl(new Type[]{Object.class}, new Type[0]);

    public static Type parameterizedClass(Class<?> clazz, Type ... typeArray) {
        return TypeFactory.parameterizedInnerClass(null, clazz, typeArray);
    }

    public static AnnotatedType annotatedClass(Class<?> clazz, Annotation[] annotationArray) {
        return TypeFactory.parameterizedAnnotatedClass(clazz, annotationArray, new AnnotatedType[0]);
    }

    public static AnnotatedType parameterizedAnnotatedClass(Class<?> clazz, Annotation[] annotationArray, AnnotatedType ... annotatedTypeArray) {
        return TypeFactory.parameterizedAnnotatedInnerClass(null, clazz, annotationArray, annotatedTypeArray);
    }

    public static AnnotatedType annotatedInnerClass(Type type, Class<?> clazz, Annotation[] annotationArray) {
        return TypeFactory.parameterizedAnnotatedInnerClass(type, clazz, annotationArray, new AnnotatedType[0]);
    }

    public static AnnotatedType parameterizedAnnotatedInnerClass(Type type, Class<?> clazz, Annotation[] annotationArray, AnnotatedType ... annotatedTypeArray) {
        if (annotatedTypeArray == null || annotatedTypeArray.length == 0) {
            return GenericTypeReflector.annotate(clazz, annotationArray);
        }
        Type[] typeArray = (Type[])Arrays.stream(annotatedTypeArray).map(AnnotatedType::getType).toArray(Type[]::new);
        return new AnnotatedParameterizedTypeImpl((ParameterizedType)TypeFactory.parameterizedInnerClass(type, clazz, typeArray), annotationArray, annotatedTypeArray);
    }

    public static AnnotatedParameterizedType parameterizedAnnotatedType(ParameterizedType parameterizedType, Annotation[] annotationArray, Annotation[] ... annotationArray2) {
        if (annotationArray2 == null || annotationArray2.length == 0) {
            return (AnnotatedParameterizedType)GenericTypeReflector.annotate((Type)parameterizedType, annotationArray);
        }
        AnnotatedType[] annotatedTypeArray = new AnnotatedType[parameterizedType.getActualTypeArguments().length];
        for (int i = 0; i < annotatedTypeArray.length; ++i) {
            Annotation[] annotationArray3 = annotationArray2.length > i ? annotationArray2[i] : null;
            annotatedTypeArray[i] = GenericTypeReflector.annotate(parameterizedType.getActualTypeArguments()[i], annotationArray3);
        }
        return (AnnotatedParameterizedType)TypeFactory.parameterizedAnnotatedClass(GenericTypeReflector.erase(parameterizedType), annotationArray, annotatedTypeArray);
    }

    public static Type innerClass(Type type, Class<?> clazz) {
        return TypeFactory.parameterizedInnerClass(type, clazz, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Type parameterizedInnerClass(Type type, Class<?> clazz, Type ... typeArray) {
        if (clazz.getDeclaringClass() == null && type != null) {
            throw new IllegalArgumentException("Cannot specify an owner type for a top level class");
        }
        Type type2 = TypeFactory.transformOwner(type, clazz);
        if (typeArray == null) {
            if (clazz.getTypeParameters().length != 0) return clazz;
            typeArray = new Type[]{};
        } else if (typeArray.length != clazz.getTypeParameters().length) {
            throw new IllegalArgumentException("Incorrect number of type arguments for [" + clazz + "]: expected " + clazz.getTypeParameters().length + ", but got " + typeArray.length);
        }
        if (!GenericTypeReflector.isMissingTypeParameters(clazz)) {
            return clazz;
        }
        if (type2 != null && !Modifier.isStatic(clazz.getModifiers()) && GenericTypeReflector.isMissingTypeParameters(type2)) {
            return clazz;
        }
        ParameterizedTypeImpl parameterizedTypeImpl = new ParameterizedTypeImpl(clazz, typeArray, type2);
        TypeFactory.checkParametersWithinBound(parameterizedTypeImpl);
        return parameterizedTypeImpl;
    }

    private static void checkParametersWithinBound(ParameterizedType parameterizedType) {
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        TypeVariable<Class<T>>[] typeVariableArray = ((Class)parameterizedType.getRawType()).getTypeParameters();
        VarMap varMap = new VarMap(parameterizedType);
        for (int i = 0; i < typeArray.length; ++i) {
            for (Type type : typeVariableArray[i].getBounds()) {
                Type type2 = varMap.map(type);
                if (typeArray[i] instanceof WildcardType) {
                    WildcardType wildcardType = (WildcardType)typeArray[i];
                    for (Type type3 : wildcardType.getUpperBounds()) {
                        if (TypeFactory.couldHaveCommonSubtype(type2, type3)) continue;
                        throw new TypeArgumentNotInBoundException(typeArray[i], typeVariableArray[i], type);
                    }
                    for (Type type3 : wildcardType.getLowerBounds()) {
                        if (GenericTypeReflector.isSuperType(type2, type3)) continue;
                        throw new TypeArgumentNotInBoundException(typeArray[i], typeVariableArray[i], type);
                    }
                    continue;
                }
                if (GenericTypeReflector.isSuperType(type2, typeArray[i])) continue;
                throw new TypeArgumentNotInBoundException(typeArray[i], typeVariableArray[i], type);
            }
        }
    }

    private static boolean couldHaveCommonSubtype(Type type, Type type2) {
        Class<?> clazz = GenericTypeReflector.erase(type);
        Class<?> clazz2 = GenericTypeReflector.erase(type2);
        return clazz.isInterface() || clazz2.isInterface() || clazz.isAssignableFrom(clazz2) || clazz2.isAssignableFrom(clazz);
    }

    private static Type transformOwner(Type type, Class<?> clazz) {
        if (type == null) {
            return clazz.getDeclaringClass();
        }
        Type type2 = GenericTypeReflector.getExactSuperType(GenericTypeReflector.annotate(type).getType(), clazz.getDeclaringClass());
        if (type2 == null) {
            throw new IllegalArgumentException("Given owner type [" + type + "] is not appropriate for [" + clazz + "]: it should be a subtype of " + clazz.getDeclaringClass());
        }
        if (Modifier.isStatic(clazz.getModifiers())) {
            return GenericTypeReflector.erase(type2);
        }
        return type2;
    }

    public static WildcardType unboundWildcard() {
        return UNBOUND_WILDCARD;
    }

    public static WildcardType wildcardExtends(Type type) {
        if (type == null) {
            throw new NullPointerException();
        }
        return new WildcardTypeImpl(new Type[]{type}, new Type[0]);
    }

    public static WildcardType wildcardSuper(Type type) {
        if (type == null) {
            throw new NullPointerException();
        }
        return new WildcardTypeImpl(new Type[]{Object.class}, new Type[]{type});
    }

    public static Type arrayOf(Type type) {
        return GenericArrayTypeImpl.createArrayType(type);
    }

    public static AnnotatedArrayType arrayOf(AnnotatedType annotatedType, Annotation[] annotationArray) {
        return AnnotatedArrayTypeImpl.createArrayType(annotatedType, annotationArray);
    }

    public static <A extends Annotation> A annotation(Class<A> clazz, Map<String, Object> map) {
        return (A)((Annotation)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new AnnotationInvocationHandler(clazz, map == null ? Collections.emptyMap() : map)));
    }
}

