/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate;

import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.geantyref.GenericTypeReflector;
import us.ajg0702.queue.libs.sponge.configurate.ConfigValue;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurateException;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationOptions;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationVisitor;
import us.ajg0702.queue.libs.sponge.configurate.ListConfigValue;
import us.ajg0702.queue.libs.sponge.configurate.MapConfigValue;
import us.ajg0702.queue.libs.sponge.configurate.NodePath;
import us.ajg0702.queue.libs.sponge.configurate.NullConfigValue;
import us.ajg0702.queue.libs.sponge.configurate.RepresentationHint;
import us.ajg0702.queue.libs.sponge.configurate.ScalarConfigValue;
import us.ajg0702.queue.libs.sponge.configurate.ScopedConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.VisitorNodeEnd;
import us.ajg0702.queue.libs.sponge.configurate.VisitorSafeNoopException;
import us.ajg0702.queue.libs.sponge.configurate.serialize.SerializationException;
import us.ajg0702.queue.libs.sponge.configurate.serialize.TypeSerializer;
import us.ajg0702.queue.libs.sponge.configurate.util.UnmodifiableCollections;

abstract class AbstractConfigurationNode<N extends ScopedConfigurationNode<N>, A extends AbstractConfigurationNode<N, A>>
implements ScopedConfigurationNode<N> {
    private final ConfigurationOptions options;
    volatile boolean attached;
    volatile @Nullable Object key;
    private @Nullable A parent;
    volatile ConfigValue<N, A> value;
    final Map<RepresentationHint<?>, Object> hints;

    protected AbstractConfigurationNode(@Nullable Object object, @Nullable A a, ConfigurationOptions configurationOptions) {
        Objects.requireNonNull(configurationOptions, "options");
        if (object == null != (a == null)) {
            throw new IllegalArgumentException("A node's key and parent must share the same nullability status");
        }
        this.key = object;
        this.options = configurationOptions;
        this.parent = a;
        this.value = NullConfigValue.instance();
        this.hints = new ConcurrentHashMap();
        if (a == null) {
            this.attached = true;
        }
    }

    protected AbstractConfigurationNode(@Nullable A a, A a2) {
        this.options = ((AbstractConfigurationNode)a2).options();
        this.attached = true;
        this.key = ((AbstractConfigurationNode)a2).key;
        this.parent = a;
        this.value = ((AbstractConfigurationNode)a2).value.copy(this.implSelf());
        this.hints = new ConcurrentHashMap(((AbstractConfigurationNode)a2).hints);
    }

    static <V> V storeDefault(ConfigurationNode configurationNode, Type type, V v) {
        Objects.requireNonNull(v, "defValue");
        if (configurationNode.options().shouldCopyDefaults()) {
            configurationNode.set(type, v);
        }
        return v;
    }

    @Override
    public final @Nullable Object get(Type type) {
        Objects.requireNonNull(type, "type");
        if (GenericTypeReflector.isMissingTypeParameters(type)) {
            throw new SerializationException((ConfigurationNode)this, type, "Raw types are not supported");
        }
        @Nullable TypeSerializer<?> typeSerializer = this.options().serializers().get(type);
        if (this.value instanceof NullConfigValue) {
            Object obj;
            if (typeSerializer != null && this.options().implicitInitialization() && (obj = typeSerializer.emptyValue(type, this.options)) != null) {
                return AbstractConfigurationNode.storeDefault(this, type, obj);
            }
            return null;
        }
        if (typeSerializer == null) {
            @Nullable Object object = this.raw();
            Class<?> clazz = GenericTypeReflector.erase(type);
            if (clazz.isInstance(object)) {
                return object;
            }
            return null;
        }
        try {
            return typeSerializer.deserialize(type, (ConfigurationNode)this.self());
        }
        catch (SerializationException serializationException) {
            serializationException.initPath(this::path);
            serializationException.initType(type);
            throw serializationException;
        }
    }

    @Override
    public final N set(@Nullable Object object) {
        if (object instanceof ConfigurationNode) {
            this.from((ConfigurationNode)object);
            return this.self();
        }
        if (object == null) {
            @Nullable Object object2 = this.key;
            if (this.parent == null || object2 == null) {
                this.clear();
            } else {
                ((AbstractConfigurationNode)this.parent).removeChild(object2);
            }
            return this.self();
        }
        if (object instanceof Collection || object instanceof Map) {
            this.insertNewValue(object, false);
            return this.self();
        }
        return (N)this.set((Type)object.getClass(), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public N from(ConfigurationNode configurationNode) {
        if (configurationNode == this) {
            return this.self();
        }
        this.hints.clear();
        this.hints.putAll(configurationNode.ownHints());
        if (configurationNode.isList()) {
            this.attachIfNecessary();
            ListConfigValue listConfigValue = new ListConfigValue(this.implSelf());
            ConfigurationNode configurationNode2 = configurationNode;
            synchronized (configurationNode2) {
                List<? extends ConfigurationNode> list = configurationNode.childrenList();
                for (int i = 0; i < list.size(); ++i) {
                    A a = this.createNode(i);
                    ((AbstractConfigurationNode)a).attached = true;
                    ((AbstractConfigurationNode)a).from(list.get(i));
                    listConfigValue.putChild(i, a);
                }
            }
            this.value = listConfigValue;
        } else if (configurationNode.isMap()) {
            this.attachIfNecessary();
            MapConfigValue mapConfigValue = new MapConfigValue(this.implSelf());
            ConfigurationNode configurationNode3 = configurationNode;
            synchronized (configurationNode3) {
                for (Map.Entry<Object, ? extends ConfigurationNode> entry : configurationNode.childrenMap().entrySet()) {
                    A a = this.createNode(entry.getKey());
                    ((AbstractConfigurationNode)a).attached = true;
                    ((AbstractConfigurationNode)a).from(entry.getValue());
                    mapConfigValue.putChild(entry.getKey(), a);
                }
            }
            this.value = mapConfigValue;
        } else {
            this.raw(configurationNode.raw());
        }
        return this.self();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNewValue(Object object, boolean bl) {
        if (object instanceof ConfigurationNode) {
            throw new IllegalArgumentException("Cannot set a node as the raw value of another node");
        }
        this.attachIfNecessary();
        AbstractConfigurationNode abstractConfigurationNode = this;
        synchronized (abstractConfigurationNode) {
            ConfigValue<N, A> configValue;
            ConfigValue<N, A> configValue2 = configValue = this.value;
            if (bl && !(configValue2 instanceof NullConfigValue)) {
                return;
            }
            if (object instanceof Collection) {
                if (!(configValue instanceof ListConfigValue)) {
                    configValue = new ListConfigValue(this.implSelf());
                }
            } else if (object instanceof Map) {
                if (!(configValue instanceof MapConfigValue)) {
                    configValue = new MapConfigValue(this.implSelf());
                }
            } else if (!(configValue instanceof ScalarConfigValue)) {
                configValue = new ScalarConfigValue(this.implSelf());
            }
            configValue.set(object);
            this.value = configValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public N mergeFrom(ConfigurationNode configurationNode) {
        if ((this.virtual() || this.empty()) && !configurationNode.virtual()) {
            return (N)this.from(configurationNode);
        }
        this.hints.putAll(configurationNode.ownHints());
        if (configurationNode.isMap()) {
            AbstractConfigurationNode abstractConfigurationNode = this;
            synchronized (abstractConfigurationNode) {
                ConfigValue<N, A> configValue;
                ConfigValue<N, A> configValue2 = configValue = this.value;
                if (!(configValue2 instanceof MapConfigValue)) {
                    if (configValue2 instanceof NullConfigValue) {
                        configValue = new MapConfigValue(this.implSelf());
                    } else {
                        return this.self();
                    }
                }
                for (Map.Entry<Object, ? extends ConfigurationNode> entry : configurationNode.childrenMap().entrySet()) {
                    @Nullable A a = configValue.child(entry.getKey());
                    if (a != null && ((AbstractConfigurationNode)a).raw() != null && entry.getValue().raw() == null) continue;
                    A a2 = this.createNode(entry.getKey());
                    ((AbstractConfigurationNode)a2).attached = true;
                    ((AbstractConfigurationNode)a2).from(entry.getValue());
                    @Nullable A a3 = configValue.putChildIfAbsent(entry.getKey(), a2);
                    if (a3 == null) continue;
                    ((AbstractConfigurationNode)a3).mergeFrom((ConfigurationNode)a2);
                }
                this.value = configValue;
            }
        } else if (configurationNode.isList()) {
            if (this.virtual()) {
                this.from(configurationNode);
            }
        } else if (configurationNode.rawScalar() != null) {
            this.insertNewValue(configurationNode.rawScalar(), true);
        }
        return this.self();
    }

    @Override
    public final @Nullable Object raw() {
        return this.value.get();
    }

    @Override
    public final N raw(@Nullable Object object) {
        if (object == null) {
            @Nullable Object object2 = this.key;
            if (this.parent == null || object2 == null) {
                this.clear();
            } else {
                ((AbstractConfigurationNode)this.parent).removeChild(object2);
            }
        } else {
            this.insertNewValue(object, false);
        }
        return this.self();
    }

    @Override
    public final @Nullable Object rawScalar() {
        ConfigValue<N, A> configValue = this.value;
        if (configValue instanceof ScalarConfigValue) {
            return configValue.get();
        }
        return null;
    }

    @Override
    public final N node(Object ... objectArray) {
        A a = this.implSelf();
        for (Object object : objectArray) {
            a = ((AbstractConfigurationNode)a).child(Objects.requireNonNull(object, () -> "element in path " + Arrays.toString(objectArray)), false);
        }
        return a.self();
    }

    @Override
    public final N node(Iterable<?> iterable) {
        A a = this.implSelf();
        for (Object obj : iterable) {
            a = ((AbstractConfigurationNode)a).child(Objects.requireNonNull(obj, () -> "element in path " + iterable), false);
        }
        return a.self();
    }

    @Override
    public final boolean hasChild(Object ... objectArray) {
        A a = this.implSelf();
        for (Object object : objectArray) {
            @Nullable A a2 = ((AbstractConfigurationNode)a).value.child(Objects.requireNonNull(object, () -> "element in path " + Arrays.toString(objectArray)));
            if (a2 == null) {
                return false;
            }
            a = a2;
        }
        return true;
    }

    @Override
    public final boolean hasChild(Iterable<?> iterable) {
        A a = this.implSelf();
        for (Object obj : iterable) {
            @Nullable A a2 = ((AbstractConfigurationNode)a).value.child(Objects.requireNonNull(obj, () -> "element in path " + iterable));
            if (a2 == null) {
                return false;
            }
            a = a2;
        }
        return true;
    }

    @Override
    public final boolean virtual() {
        return !this.attached;
    }

    @Override
    public boolean isNull() {
        return this.value instanceof NullConfigValue;
    }

    @Override
    public final boolean isList() {
        return this.value instanceof ListConfigValue;
    }

    @Override
    public final boolean isMap() {
        return this.value instanceof MapConfigValue;
    }

    @Override
    public final List<N> childrenList() {
        ConfigValue<N, A> configValue = this.value;
        return configValue instanceof ListConfigValue ? ((ListConfigValue)configValue).unwrapped() : Collections.emptyList();
    }

    @Override
    public final Map<Object, N> childrenMap() {
        ConfigValue<N, A> configValue = this.value;
        return configValue instanceof MapConfigValue ? ((MapConfigValue)configValue).unwrapped() : Collections.emptyMap();
    }

    @Override
    public boolean empty() {
        return this.value.isEmpty();
    }

    protected final A child(Object object, boolean bl) {
        @Nullable A a = this.value.child(object);
        if (a == null) {
            if (bl) {
                this.attachIfNecessary();
                a = this.createNode(object);
                @Nullable A a2 = this.value.putChildIfAbsent(object, a);
                if (a2 != null) {
                    a = a2;
                } else {
                    this.attachChild(a);
                }
            } else {
                a = this.createNode(object);
            }
        }
        return a;
    }

    @Override
    public final boolean removeChild(Object object) {
        return AbstractConfigurationNode.detachIfNonNull(this.value.putChild(object, null)) != null;
    }

    private static <N extends ScopedConfigurationNode<N>, T extends AbstractConfigurationNode<N, T>> @Nullable T detachIfNonNull(@Nullable T t) {
        if (t != null) {
            t.attached = false;
            t.clear();
        }
        return t;
    }

    @Override
    public final N appendListNode() {
        return this.child(ListConfigValue.UNALLOCATED_IDX, false).self();
    }

    @Override
    public final @Nullable Object key() {
        return this.key;
    }

    @Override
    public final NodePath path() {
        Object object = this.self();
        if (object.parent() == null) {
            return NodePath.path();
        }
        ArrayDeque<@Nullable Object> arrayDeque = new ArrayDeque<Object>();
        do {
            arrayDeque.addFirst(object.key());
        } while ((object = (ScopedConfigurationNode)Objects.requireNonNull(object.parent())).parent() != null);
        return NodePath.of(arrayDeque);
    }

    @Override
    public final @Nullable N parent() {
        @Nullable A a = this.parent;
        return a == null ? null : (N)a.self();
    }

    @Override
    public final ConfigurationOptions options() {
        return this.options;
    }

    @Override
    public final N copy() {
        return this.copy(null).self();
    }

    protected abstract A copy(@Nullable A var1);

    final @Nullable A parentEnsureAttached() {
        @Nullable A a = this.parent;
        if (a != null && ((AbstractConfigurationNode)a).virtual()) {
            a = ((AbstractConfigurationNode)((AbstractConfigurationNode)a).parentEnsureAttached()).attachChildIfAbsent(a);
        }
        this.parent = a;
        return this.parent;
    }

    protected final void attachIfNecessary() {
        A a;
        if (!this.attached && (a = this.parentEnsureAttached()) != null) {
            ((AbstractConfigurationNode)a).attachChild(this.implSelf());
        }
    }

    protected final A attachChildIfAbsent(A a) {
        return this.attachChild(a, true);
    }

    final void attachChild(A a) {
        this.attachChild(a, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private A attachChild(A a, boolean bl) {
        ConfigValue<N, A> configValue;
        ConfigValue<N, A> configValue2;
        if (this.virtual()) {
            throw new IllegalStateException("This parent is not currently attached. This is an internal state violation.");
        }
        if (!Objects.equals(((AbstractConfigurationNode)a).parentEnsureAttached(), this)) {
            throw new IllegalStateException("Child " + a + " path is not a direct parent of me (" + this.path() + "), cannot attach");
        }
        AbstractConfigurationNode abstractConfigurationNode = this;
        synchronized (abstractConfigurationNode) {
            Object object;
            configValue = configValue2 = this.value;
            if (configValue2 instanceof MapConfigValue) {
                if (((AbstractConfigurationNode)a).key == ListConfigValue.UNALLOCATED_IDX) {
                    configValue = new ListConfigValue(this.implSelf());
                }
            } else if (ListConfigValue.likelyListKey(((AbstractConfigurationNode)a).key)) {
                if (configValue2 instanceof NullConfigValue) {
                    configValue = new ListConfigValue(this.implSelf());
                } else if (!(configValue2 instanceof ListConfigValue)) {
                    configValue = new ListConfigValue(this.implSelf(), configValue2.get());
                }
            } else {
                configValue = new MapConfigValue(this.implSelf());
            }
            if ((object = ((AbstractConfigurationNode)a).key) == null) {
                throw new IllegalArgumentException("Cannot attach a child with null key");
            }
            if (bl) {
                @Nullable A a2 = configValue.putChildIfAbsent(object, a);
                if (a2 != null) {
                    return a2;
                }
            } else {
                AbstractConfigurationNode.detachIfNonNull(configValue.putChild(object, a));
            }
            this.value = configValue;
        }
        if (configValue != configValue2) {
            configValue2.clear();
        }
        ((AbstractConfigurationNode)a).attached = true;
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clear() {
        AbstractConfigurationNode abstractConfigurationNode = this;
        synchronized (abstractConfigurationNode) {
            ConfigValue<N, A> configValue = this.value;
            this.value = NullConfigValue.instance();
            configValue.clear();
        }
    }

    @Override
    public final <S, T, E extends Exception> T visit(ConfigurationVisitor<S, T, E> configurationVisitor, S s) {
        return this.visitInternal(configurationVisitor, s);
    }

    @Override
    public final <S, T> T visit(ConfigurationVisitor.Safe<S, T> safe, S s) {
        try {
            return this.visitInternal(safe, s);
        }
        catch (VisitorSafeNoopException visitorSafeNoopException) {
            throw new AssertionError("Exception was thrown on a Safe visitor", visitorSafeNoopException);
        }
    }

    private <S, T, E extends Exception> T visitInternal(ConfigurationVisitor<S, T, E> configurationVisitor, S s) {
        configurationVisitor.beginVisit((ConfigurationNode)this.self(), s);
        if (!(this.value instanceof NullConfigValue)) {
            Object e;
            LinkedList<Object> linkedList = new LinkedList<Object>();
            linkedList.add(this);
            while ((e = linkedList.pollFirst()) != null) {
                @Nullable A a = VisitorNodeEnd.popFromVisitor(e, configurationVisitor, s);
                if (a == null) continue;
                try {
                    configurationVisitor.enterNode((ConfigurationNode)a.self(), s);
                    ConfigValue<N, A> configValue = ((AbstractConfigurationNode)a).value;
                    if (configValue instanceof MapConfigValue) {
                        configurationVisitor.enterMappingNode((ConfigurationNode)a.self(), s);
                        linkedList.addFirst(new VisitorNodeEnd((ConfigurationNode)a, true));
                        linkedList.addAll(0, ((MapConfigValue)configValue).values.values());
                        continue;
                    }
                    if (configValue instanceof ListConfigValue) {
                        configurationVisitor.enterListNode((ConfigurationNode)a.self(), s);
                        linkedList.addFirst(new VisitorNodeEnd((ConfigurationNode)a, false));
                        linkedList.addAll(0, ((ListConfigValue)configValue).values);
                        continue;
                    }
                    if (configValue instanceof ScalarConfigValue) {
                        configurationVisitor.enterScalarNode((ConfigurationNode)a.self(), s);
                        continue;
                    }
                    if (configValue instanceof NullConfigValue) continue;
                    throw new IllegalStateException("Unknown value type " + configValue.getClass() + " at " + ((AbstractConfigurationNode)a).path());
                }
                catch (Exception exception) {
                    if (exception instanceof ConfigurateException) {
                        ((ConfigurateException)exception).initPath(() -> a.path());
                    }
                    throw exception;
                }
            }
        }
        return configurationVisitor.endVisit(s);
    }

    @Override
    public final <V> N hint(RepresentationHint<V> representationHint, @Nullable V v) {
        if (v == null) {
            this.hints.remove(representationHint);
        } else {
            this.hints.put(representationHint, v);
        }
        return this.self();
    }

    @Override
    public final <V> @Nullable V hint(RepresentationHint<V> representationHint) {
        Object object = this.hints.get(representationHint);
        if (object != null) {
            return (V)object;
        }
        @Nullable A a = this.parent;
        if (a != null && representationHint.inheritable()) {
            return ((AbstractConfigurationNode)a).hint(representationHint);
        }
        return representationHint.defaultValue();
    }

    @Override
    public final <V> @Nullable V ownHint(RepresentationHint<V> representationHint) {
        return (V)this.hints.get(representationHint);
    }

    @Override
    public final Map<RepresentationHint<?>, ?> ownHints() {
        return UnmodifiableCollections.copyOf(this.hints);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractConfigurationNode)) {
            return false;
        }
        AbstractConfigurationNode abstractConfigurationNode = (AbstractConfigurationNode)object;
        return Objects.equals(this.key, abstractConfigurationNode.key) && Objects.equals(this.value, abstractConfigurationNode.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
    }

    public String toString() {
        return "AbstractConfigurationNode{key=" + this.key + ", value=" + this.value + '}';
    }

    protected abstract A createNode(Object var1);

    protected abstract A implSelf();
}

