/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate;

import java.io.IOException;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.NodePath;

public class ConfigurateException
extends IOException {
    private static final long serialVersionUID = 1635526451813128733L;
    private @Nullable Supplier<NodePath> path;

    public static ConfigurateException wrap(ConfigurationNode configurationNode, IOException iOException) {
        if (iOException instanceof ConfigurateException) {
            return (ConfigurateException)iOException;
        }
        return new ConfigurateException(configurationNode, (Throwable)iOException);
    }

    public ConfigurateException() {
    }

    public ConfigurateException(String string) {
        super(string);
    }

    public ConfigurateException(Throwable throwable) {
        super(throwable);
    }

    public ConfigurateException(@Nullable String string, @Nullable Throwable throwable) {
        super(string, throwable);
    }

    public ConfigurateException(ConfigurationNode configurationNode, String string) {
        super(string);
        this.path = configurationNode::path;
    }

    public ConfigurateException(ConfigurationNode configurationNode, Throwable throwable) {
        super(throwable);
        this.path = configurationNode::path;
    }

    public ConfigurateException(ConfigurationNode configurationNode, @Nullable String string, @Nullable Throwable throwable) {
        super(string, throwable);
        this.path = configurationNode::path;
    }

    public ConfigurateException(NodePath nodePath, @Nullable String string, @Nullable Throwable throwable) {
        super(string, throwable);
        this.path = () -> nodePath;
    }

    public NodePath path() {
        @Nullable Supplier<NodePath> supplier = this.path;
        return supplier == null ? NodePath.path() : supplier.get();
    }

    public void initPath(Supplier<NodePath> supplier) {
        if (this.path == null) {
            this.path = supplier;
        }
    }

    public @Nullable String rawMessage() {
        return super.getMessage();
    }

    @Override
    public @Nullable String getMessage() {
        return this.path().toString() + ": " + super.getMessage();
    }
}

