/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.objectmapping;

import com.google.auto.value.AutoValue;
import java.lang.reflect.AnnotatedType;
import java.util.List;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.geantyref.GenericTypeReflector;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.objectmapping.AutoValue_FieldData;
import us.ajg0702.queue.libs.sponge.configurate.objectmapping.meta.Constraint;
import us.ajg0702.queue.libs.sponge.configurate.objectmapping.meta.NodeResolver;
import us.ajg0702.queue.libs.sponge.configurate.objectmapping.meta.Processor;
import us.ajg0702.queue.libs.sponge.configurate.serialize.SerializationException;
import us.ajg0702.queue.libs.sponge.configurate.serialize.TypeSerializer;
import us.ajg0702.queue.libs.sponge.configurate.util.CheckedFunction;
import us.ajg0702.queue.libs.sponge.configurate.util.UnmodifiableCollections;

@AutoValue
public abstract class FieldData<I, O> {
    static <I, O> FieldData<I, O> of(String string, AnnotatedType annotatedType, List<Constraint<?>> list, List<Processor<?>> list2, Deserializer<I> deserializer, CheckedFunction<O, @Nullable Object, Exception> checkedFunction, NodeResolver nodeResolver) {
        return new AutoValue_FieldData<I, O>(string, annotatedType, UnmodifiableCollections.copyOf(list), UnmodifiableCollections.copyOf(list2), deserializer, checkedFunction, nodeResolver);
    }

    FieldData() {
    }

    public abstract String name();

    public abstract AnnotatedType resolvedType();

    abstract List<Constraint<?>> constraints();

    abstract List<Processor<?>> processors();

    abstract Deserializer<I> deserializer();

    abstract CheckedFunction<O, @Nullable Object, Exception> serializer();

    abstract NodeResolver nodeResolver();

    public boolean isValid(Object object) {
        try {
            this.validate(object);
            return true;
        }
        catch (SerializationException serializationException) {
            return false;
        }
    }

    public void validate(@Nullable Object object) {
        if (object != null && !GenericTypeReflector.erase(GenericTypeReflector.box(this.resolvedType().getType())).isInstance(object)) {
            throw new SerializationException("Object " + object + " is not of expected type " + this.resolvedType().getType());
        }
        for (Constraint<?> constraint : this.constraints()) {
            constraint.validate(object);
        }
    }

    TypeSerializer<?> serializerFrom(ConfigurationNode configurationNode) {
        @Nullable TypeSerializer<?> typeSerializer = configurationNode.options().serializers().get(this.resolvedType().getType());
        if (typeSerializer == null) {
            throw new SerializationException("No TypeSerializer found for field " + this.name() + " of type " + this.resolvedType().getType());
        }
        return typeSerializer;
    }

    public @Nullable ConfigurationNode resolveNode(ConfigurationNode configurationNode) {
        return this.nodeResolver().resolve(configurationNode);
    }

    @FunctionalInterface
    public static interface Deserializer<I> {
        public void accept(I var1, @Nullable Object var2, Supplier<@Nullable Object> var3);
    }
}

