/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.objectmapping;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.geantyref.GenericTypeReflector;
import us.ajg0702.queue.libs.sponge.configurate.BasicConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationOptions;
import us.ajg0702.queue.libs.sponge.configurate.objectmapping.Definition;
import us.ajg0702.queue.libs.sponge.configurate.objectmapping.FieldData;
import us.ajg0702.queue.libs.sponge.configurate.objectmapping.FieldDiscoverer;
import us.ajg0702.queue.libs.sponge.configurate.objectmapping.ObjectMapper;
import us.ajg0702.queue.libs.sponge.configurate.objectmapping.ObjectMapperImpl;
import us.ajg0702.queue.libs.sponge.configurate.objectmapping.meta.Comment;
import us.ajg0702.queue.libs.sponge.configurate.objectmapping.meta.Constraint;
import us.ajg0702.queue.libs.sponge.configurate.objectmapping.meta.Matches;
import us.ajg0702.queue.libs.sponge.configurate.objectmapping.meta.NodeResolver;
import us.ajg0702.queue.libs.sponge.configurate.objectmapping.meta.Processor;
import us.ajg0702.queue.libs.sponge.configurate.objectmapping.meta.Required;
import us.ajg0702.queue.libs.sponge.configurate.serialize.SerializationException;
import us.ajg0702.queue.libs.sponge.configurate.serialize.TypeSerializer;
import us.ajg0702.queue.libs.sponge.configurate.util.CheckedFunction;
import us.ajg0702.queue.libs.sponge.configurate.util.NamingScheme;
import us.ajg0702.queue.libs.sponge.configurate.util.NamingSchemes;

final class ObjectMapperFactoryImpl
implements ObjectMapper.Factory,
TypeSerializer<Object> {
    private static final int MAXIMUM_MAPPERS_SIZE = 64;
    private final Map<Type, ObjectMapper<?>> mappers = new LinkedHashMap<Type, ObjectMapper<?>>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Type, ObjectMapper<?>> entry) {
            return this.size() > 64;
        }
    };
    private final List<NodeResolver.Factory> resolverFactories;
    private final List<FieldDiscoverer<?>> fieldDiscoverers;
    private final Map<Class<? extends Annotation>, List<Definition<?, ?, ? extends Constraint.Factory<?, ?>>>> constraints;
    private final Map<Class<? extends Annotation>, List<Definition<?, ?, ? extends Processor.Factory<?, ?>>>> processors;
    public static final String CLASS_KEY = "__class__";
    static final ObjectMapper.Factory INSTANCE = ObjectMapperFactoryImpl.defaultBuilder().build();

    ObjectMapperFactoryImpl(Builder builder) {
        this.resolverFactories = new ArrayList<NodeResolver.Factory>(builder.resolvers);
        Collections.reverse(this.resolverFactories);
        @Nullable NamingScheme namingScheme = builder.namingScheme;
        if (namingScheme != null) {
            this.resolverFactories.add((string, annotatedElement) -> {
                String string2 = namingScheme.coerce(string);
                return configurationNode -> configurationNode.node(string2);
            });
        }
        this.fieldDiscoverers = new ArrayList(builder.discoverer);
        Collections.reverse(this.fieldDiscoverers);
        this.constraints = new HashMap();
        for (Definition definition : builder.constraints) {
            this.constraints.computeIfAbsent(definition.annotation(), clazz -> new ArrayList()).add(definition);
        }
        this.constraints.values().forEach(Collections::reverse);
        this.processors = new HashMap();
        for (Definition definition : builder.processors) {
            this.processors.computeIfAbsent(definition.annotation(), clazz -> new ArrayList()).add(definition);
        }
        this.processors.values().forEach(Collections::reverse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectMapper<?> get(Type type) {
        Objects.requireNonNull(type, "type");
        if (GenericTypeReflector.isMissingTypeParameters(type)) {
            throw new SerializationException(type, "Raw types are not supported!");
        }
        Map<Type, ObjectMapper<?>> map = this.mappers;
        synchronized (map) {
            return ObjectMapperFactoryImpl.computeFromMap(this.mappers, type, this::computeMapper);
        }
    }

    @Override
    public TypeSerializer<Object> asTypeSerializer() {
        return this;
    }

    private ObjectMapper<?> computeMapper(Type type) {
        for (FieldDiscoverer<?> fieldDiscoverer : this.fieldDiscoverers) {
            @Nullable ObjectMapper<V> objectMapper = this.newMapper(type, fieldDiscoverer);
            if (objectMapper == null) continue;
            return objectMapper;
        }
        throw new SerializationException(type, "Could not find factory for type " + type);
    }

    private <I, V> @Nullable ObjectMapper<V> newMapper(Type type, FieldDiscoverer<I> fieldDiscoverer) {
        ArrayList arrayList = new ArrayList();
        @Nullable FieldDiscoverer.InstanceFactory<I> instanceFactory = fieldDiscoverer.discover(GenericTypeReflector.annotate(type), (string, annotatedType, annotatedElement, deserializer, checkedFunction) -> this.makeData(arrayList, string, annotatedType, annotatedElement, deserializer, checkedFunction));
        if (instanceFactory == null) {
            return null;
        }
        if (instanceFactory instanceof FieldDiscoverer.MutableInstanceFactory) {
            return new ObjectMapperImpl.Mutable(type, arrayList, (FieldDiscoverer.MutableInstanceFactory)instanceFactory);
        }
        return new ObjectMapperImpl(type, arrayList, instanceFactory);
    }

    private <I, O> void makeData(List<FieldData<I, O>> list, String string, AnnotatedType annotatedType, AnnotatedElement annotatedElement, FieldData.Deserializer<I> deserializer, CheckedFunction<O, @Nullable Object, Exception> checkedFunction) {
        Object object;
        Object object3 = null;
        for (NodeResolver.Factory object22 : this.resolverFactories) {
            object = object22.make(string, annotatedElement);
            if (object == null) continue;
            if (object == NodeResolver.SKIP_FIELD) break;
            object3 = object;
            break;
        }
        if (object3 == null) {
            return;
        }
        Type type = GenericTypeReflector.box(annotatedType.getType());
        ArrayList arrayList = new ArrayList();
        object = new ArrayList();
        for (Annotation annotation : annotatedElement.getAnnotations()) {
            Definition<?, ?, Constraint.Factory<?, ?>> definition;
            Object object2;
            List<Definition<?, ?, Constraint.Factory<?, ?>>> list2 = this.constraints.get(annotation.annotationType());
            if (list2 != null) {
                object2 = list2.iterator();
                while (object2.hasNext()) {
                    definition = object2.next();
                    if (!GenericTypeReflector.isSuperType(definition.type(), type)) continue;
                    arrayList.add(((Constraint.Factory)definition.factory()).make(annotation, annotatedType.getType()));
                }
            }
            if ((object2 = this.processors.get(annotation.annotationType())) == null) continue;
            definition = object2.iterator();
            while (definition.hasNext()) {
                Definition definition2 = (Definition)definition.next();
                if (!GenericTypeReflector.isSuperType(definition2.type(), type)) continue;
                object.add(((Processor.Factory)definition2.factory()).make(annotation, annotatedType.getType()));
            }
        }
        list.add(FieldData.of(string, annotatedType, arrayList, object, deserializer, checkedFunction, (NodeResolver)object3));
    }

    @Override
    public Object deserialize(Type type, ConfigurationNode configurationNode) {
        Type type2 = this.instantiableType(configurationNode, type, configurationNode.node(CLASS_KEY).getString());
        return this.get(type2).load(configurationNode);
    }

    private Type instantiableType(ConfigurationNode configurationNode, Type clazz, @Nullable String string) {
        Class<?> clazz2;
        Class<?> clazz3 = GenericTypeReflector.erase(clazz);
        if (clazz3.isInterface() || Modifier.isAbstract(clazz3.getModifiers())) {
            if (string == null) {
                throw new SerializationException(configurationNode, clazz, "No available configured type for instances of this type");
            }
            try {
                clazz2 = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SerializationException(configurationNode, clazz, "Unknown class of object " + string, classNotFoundException);
            }
            if (!GenericTypeReflector.isSuperType(clazz, clazz2)) {
                throw new SerializationException(configurationNode, clazz, "Configured type " + string + " does not extend " + clazz3.getCanonicalName());
            }
        } else {
            clazz2 = clazz;
        }
        return clazz2;
    }

    @Override
    public void serialize(Type type, @Nullable Object object, ConfigurationNode configurationNode) {
        ObjectMapper<?> objectMapper;
        if (object == null) {
            ConfigurationNode configurationNode2 = configurationNode.node(CLASS_KEY);
            configurationNode.set(null);
            if (!configurationNode2.virtual()) {
                configurationNode.node(CLASS_KEY).set(configurationNode2);
            }
            return;
        }
        Class<?> clazz = GenericTypeReflector.erase(type);
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            configurationNode.node(CLASS_KEY).set(object.getClass().getName());
            objectMapper = this.get(object.getClass());
        } else {
            objectMapper = this.get(type);
        }
        objectMapper.save(object, configurationNode);
    }

    @Override
    public @Nullable Object emptyValue(Type type, ConfigurationOptions configurationOptions) {
        try {
            return this.get(type).load(BasicConfigurationNode.root(configurationOptions.shouldCopyDefaults(false)));
        }
        catch (SerializationException serializationException) {
            return null;
        }
    }

    private static <K, V, E extends Exception> V computeFromMap(Map<K, V> map, K k, CheckedFunction<K, V, E> checkedFunction) {
        try {
            return (V)map.computeIfAbsent(k, object -> {
                try {
                    return checkedFunction.apply(object);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new StacklessWrapper(exception);
                }
            });
        }
        catch (StacklessWrapper stacklessWrapper) {
            throw (Exception)stacklessWrapper.getCause();
        }
    }

    static ObjectMapper.Factory.Builder defaultBuilder() {
        return new Builder().defaultNamingScheme(NamingSchemes.LOWER_CASE_DASHED).addNodeResolver(NodeResolver.nodeKey()).addNodeResolver(NodeResolver.keyFromSetting()).addNodeResolver(NodeResolver.nodeFromParent()).addProcessor(Comment.class, Processor.comments()).addConstraint(Matches.class, String.class, Constraint.pattern()).addConstraint(Required.class, Constraint.required()).addDiscoverer(FieldDiscoverer.emptyConstructorObject()).addDiscoverer(FieldDiscoverer.record());
    }

    static class Builder
    implements ObjectMapper.Factory.Builder {
        private @Nullable NamingScheme namingScheme;
        private final List<NodeResolver.Factory> resolvers = new ArrayList<NodeResolver.Factory>();
        private final List<FieldDiscoverer<?>> discoverer = new ArrayList();
        private final List<Definition<?, ?, ? extends Constraint.Factory<?, ?>>> constraints = new ArrayList();
        private final List<Definition<?, ?, ? extends Processor.Factory<?, ?>>> processors = new ArrayList();

        Builder() {
        }

        @Override
        public ObjectMapper.Factory.Builder defaultNamingScheme(NamingScheme namingScheme) {
            this.namingScheme = namingScheme;
            return this;
        }

        @Override
        public Builder addNodeResolver(NodeResolver.Factory factory) {
            this.resolvers.add(factory);
            return this;
        }

        @Override
        public Builder addDiscoverer(FieldDiscoverer<?> fieldDiscoverer) {
            this.discoverer.add(fieldDiscoverer);
            return this;
        }

        @Override
        public <A extends Annotation, T> Builder addProcessor(Class<A> clazz, Class<T> clazz2, Processor.Factory<A, T> factory) {
            this.processors.add(Definition.of(clazz, clazz2, factory));
            return this;
        }

        @Override
        public <A extends Annotation, T> Builder addConstraint(Class<A> clazz, Class<T> clazz2, Constraint.Factory<A, T> factory) {
            this.constraints.add(Definition.of(clazz, clazz2, factory));
            return this;
        }

        @Override
        public ObjectMapper.Factory build() {
            return new ObjectMapperFactoryImpl(this);
        }
    }

    private static class StacklessWrapper
    extends RuntimeException {
        private static final long serialVersionUID = 1759625646560465255L;

        StacklessWrapper(Throwable throwable) {
            super(throwable);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

