/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.objectmapping;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.objectmapping.FieldData;
import us.ajg0702.queue.libs.sponge.configurate.objectmapping.FieldDiscoverer;
import us.ajg0702.queue.libs.sponge.configurate.objectmapping.ObjectMapper;
import us.ajg0702.queue.libs.sponge.configurate.objectmapping.meta.Processor;
import us.ajg0702.queue.libs.sponge.configurate.serialize.SerializationException;
import us.ajg0702.queue.libs.sponge.configurate.serialize.TypeSerializer;
import us.ajg0702.queue.libs.sponge.configurate.util.CheckedFunction;

class ObjectMapperImpl<I, V>
implements ObjectMapper<V> {
    private final Type type;
    private final List<FieldData<I, V>> fields;
    final FieldDiscoverer.InstanceFactory<I> instanceFactory;

    ObjectMapperImpl(Type type, List<FieldData<I, V>> list, FieldDiscoverer.InstanceFactory<I> instanceFactory) {
        this.type = type;
        this.fields = Collections.unmodifiableList(list);
        this.instanceFactory = instanceFactory;
    }

    @Override
    public V load(ConfigurationNode configurationNode) {
        return (V)this.load0(configurationNode, object -> this.instanceFactory.complete(object));
    }

    final V load0(ConfigurationNode configurationNode, CheckedFunction<I, V, SerializationException> checkedFunction) {
        I i = this.instanceFactory.begin();
        ArrayList<Object> arrayList = null;
        SerializationException serializationException = null;
        for (FieldData<I, V> fieldData : this.fields) {
            @Nullable Object object = fieldData.resolveNode(configurationNode);
            if (object == null) continue;
            try {
                TypeSerializer<?> typeSerializer = fieldData.serializerFrom((ConfigurationNode)object);
                @Nullable Object var10_11 = object.isNull() ? null : typeSerializer.deserialize(fieldData.resolvedType().getType(), (ConfigurationNode)object);
                fieldData.validate(var10_11);
                Supplier<@Nullable Object> supplier = var10_11 == null && object.options().implicitInitialization() ? () -> ObjectMapperImpl.lambda$load0$1(typeSerializer, fieldData, (ConfigurationNode)object) : () -> null;
                fieldData.deserializer().accept(i, var10_11, supplier);
                if (var10_11 != null || !configurationNode.options().shouldCopyDefaults()) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>();
                }
                arrayList.add(fieldData);
            }
            catch (SerializationException serializationException2) {
                serializationException2.initPath(((ConfigurationNode)object)::path);
                serializationException2.initType(fieldData.resolvedType().getType());
                if (serializationException == null) {
                    serializationException = serializationException2;
                    continue;
                }
                serializationException.addSuppressed(serializationException2);
            }
        }
        if (serializationException != null) {
            throw serializationException;
        }
        Iterator<FieldData<I, Object>> iterator = checkedFunction.apply(i);
        if (arrayList != null) {
            for (@Nullable Object object : arrayList) {
                this.saveSingle((FieldData<I, V>)object, (V)iterator, configurationNode);
            }
        }
        return (V)iterator;
    }

    @Override
    public void save(V v, ConfigurationNode configurationNode) {
        for (FieldData<I, V> fieldData : this.fields) {
            this.saveSingle(fieldData, v, configurationNode);
        }
        if (configurationNode.virtual()) {
            configurationNode.set(Collections.emptyMap());
        }
    }

    private void saveSingle(FieldData<I, V> fieldData, V v, ConfigurationNode configurationNode) {
        @Nullable ConfigurationNode configurationNode2 = fieldData.resolveNode(configurationNode);
        if (configurationNode2 == null) {
            return;
        }
        try {
            Object object;
            try {
                object = fieldData.serializer().apply(v);
            }
            catch (SerializationException serializationException) {
                throw serializationException;
            }
            catch (Exception exception) {
                throw new SerializationException(configurationNode2, fieldData.resolvedType().getType(), (Throwable)exception);
            }
            if (object == null) {
                configurationNode2.set(null);
            } else {
                TypeSerializer<?> typeSerializer = fieldData.serializerFrom(configurationNode2);
                typeSerializer.serialize(fieldData.resolvedType().getType(), object, configurationNode2);
                for (Processor<?> processor : fieldData.processors()) {
                    processor.process(object, configurationNode2);
                }
            }
        }
        catch (SerializationException serializationException) {
            serializationException.initPath(configurationNode2::path);
            serializationException.initType(fieldData.resolvedType().getType());
            throw serializationException;
        }
    }

    @Override
    public List<FieldData<I, V>> fields() {
        return this.fields;
    }

    @Override
    public Type mappedType() {
        return this.type;
    }

    @Override
    public boolean canCreateInstances() {
        return this.instanceFactory.canCreateInstances();
    }

    private static /* synthetic */ Object lambda$load0$1(TypeSerializer typeSerializer, FieldData fieldData, ConfigurationNode configurationNode) {
        return typeSerializer.emptyValue(fieldData.resolvedType().getType(), configurationNode.options());
    }

    static final class Mutable<I, V>
    extends ObjectMapperImpl<I, V>
    implements ObjectMapper.Mutable<V> {
        Mutable(Type type, List<FieldData<I, V>> list, FieldDiscoverer.MutableInstanceFactory<I> mutableInstanceFactory) {
            super(type, list, mutableInstanceFactory);
        }

        @Override
        public void load(V v, ConfigurationNode configurationNode) {
            this.load0(configurationNode, object2 -> {
                ((FieldDiscoverer.MutableInstanceFactory)this.instanceFactory).complete(v, object2);
                return v;
            });
        }
    }
}

