/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.reactive;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.sponge.configurate.reactive.Disposable;
import us.ajg0702.queue.libs.sponge.configurate.reactive.NoOpDisposable;
import us.ajg0702.queue.libs.sponge.configurate.reactive.Processor;
import us.ajg0702.queue.libs.sponge.configurate.reactive.Publisher;
import us.ajg0702.queue.libs.sponge.configurate.reactive.Subscriber;
import us.ajg0702.queue.libs.sponge.configurate.reactive.TransactionFailedException;
import us.ajg0702.queue.libs.sponge.configurate.util.CheckedFunction;

class MappedProcessor<I, O>
implements Processor.Transactional<I, O> {
    private final Processor.TransactionalIso<O> processor;
    private final AtomicReference<Disposable> disposable = new AtomicReference();
    private final CheckedFunction<? super I, ? extends O, TransactionFailedException> mapper;
    private final @Nullable Publisher<I> parent;

    MappedProcessor(CheckedFunction<? super I, ? extends O, TransactionFailedException> checkedFunction, @Nullable Publisher<I> publisher) {
        this.processor = publisher == null ? Processor.createTransactional() : Processor.createTransactional(publisher.executor());
        this.mapper = checkedFunction;
        this.parent = publisher;
    }

    @Override
    public Disposable subscribe(Subscriber<? super O> subscriber) {
        Disposable disposable2 = this.processor.subscribe(subscriber);
        if (disposable2 != NoOpDisposable.INSTANCE) {
            Disposable disposable3 = this.disposable.updateAndGet(disposable -> disposable == null && this.parent != null ? this.parent.subscribe(this) : disposable);
            if (disposable3 == NoOpDisposable.INSTANCE) {
                this.processor.onClose();
                return NoOpDisposable.INSTANCE;
            }
            return () -> {
                disposable2.dispose();
                if (!this.hasSubscribers()) {
                    Disposable disposable2 = this.disposable.getAndSet(null);
                    disposable2.dispose();
                }
            };
        }
        return disposable2;
    }

    @Override
    public boolean hasSubscribers() {
        return this.processor.hasSubscribers();
    }

    @Override
    public Executor executor() {
        return this.processor.executor();
    }

    @Override
    public void beginTransaction(I i) {
        this.processor.beginTransaction(this.mapper.apply(i));
    }

    @Override
    public void commit() {
        this.processor.commit();
    }

    @Override
    public void rollback() {
        this.processor.rollback();
    }

    @Override
    public void onError(Throwable throwable) {
        this.processor.onError(throwable);
    }

    @Override
    public void onClose() {
        Disposable disposable = this.disposable.getAndSet(null);
        if (disposable != null) {
            disposable.dispose();
        }
        this.processor.onClose();
    }

    @Override
    public void inject(O o) {
        this.processor.submit(o);
    }

    @Override
    public void fallbackHandler(@Nullable Subscriber<O> subscriber) {
        this.processor.fallbackHandler(subscriber);
    }

    @Override
    public boolean closeIfUnsubscribed() {
        if (this.processor.closeIfUnsubscribed()) {
            Disposable disposable = this.disposable.getAndSet(null);
            if (disposable != null) {
                disposable.dispose();
            }
            return true;
        }
        return false;
    }
}

