/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.reactive;

import com.google.errorprone.annotations.concurrent.LockMethod;
import com.google.errorprone.annotations.concurrent.UnlockMethod;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import us.ajg0702.queue.libs.sponge.configurate.reactive.AbstractProcessor;
import us.ajg0702.queue.libs.sponge.configurate.reactive.Subscriber;
import us.ajg0702.queue.libs.sponge.configurate.reactive.TransactionFailedException;
import us.ajg0702.queue.libs.sponge.configurate.reactive.TransactionalProcessorImpl;
import us.ajg0702.queue.libs.sponge.configurate.reactive.TransactionalSubscriber;

interface TransactionalRegistration<V>
extends AbstractProcessor.Registration<V> {
    public TransactionalProcessorImpl<V> holder();

    @Override
    default public void dispose() {
        if (this.holder().registrations.remove(this)) {
            this.holder().subscriberCount.getAndDecrement();
        }
    }

    @Override
    default public void submit(V value) {
        try {
            this.beginTransaction(value);
            this.commit();
        }
        catch (TransactionFailedException ex) {
            this.rollback();
        }
    }

    public void beginTransaction(V var1) throws TransactionFailedException;

    public void commit();

    public void rollback();

    public static class Fully<V>
    implements TransactionalRegistration<V> {
        private final TransactionalProcessorImpl<V> holder;
        private final TransactionalSubscriber<? super V> sub;
        private final Lock lock = new ReentrantLock();

        Fully(TransactionalProcessorImpl<V> transactionalProcessorImpl, TransactionalSubscriber<? super V> transactionalSubscriber) {
            this.holder = transactionalProcessorImpl;
            this.sub = transactionalSubscriber;
        }

        @Override
        public TransactionalProcessorImpl<V> holder() {
            return this.holder;
        }

        @Override
        @LockMethod(value={"lock"})
        public void beginTransaction(V v) {
            this.lock.lock();
            this.sub.beginTransaction(v);
        }

        @Override
        @UnlockMethod(value={"lock"})
        public void commit() {
            try {
                this.sub.commit();
            }
            finally {
                try {
                    this.lock.unlock();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {}
            }
        }

        @Override
        @UnlockMethod(value={"lock"})
        public void rollback() {
            try {
                this.sub.rollback();
            }
            finally {
                try {
                    this.lock.unlock();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {}
            }
        }

        @Override
        public void onClose() {
            this.sub.onClose();
        }

        @Override
        public void onError(Throwable throwable) {
            this.sub.onError(throwable);
        }
    }

    public static class Wrapped<V>
    implements TransactionalRegistration<V> {
        private final AtomicReference<V> active = new AtomicReference();
        private final TransactionalProcessorImpl<V> holder;
        private final Subscriber<? super V> sub;

        Wrapped(TransactionalProcessorImpl<V> transactionalProcessorImpl, Subscriber<? super V> subscriber) {
            this.holder = transactionalProcessorImpl;
            this.sub = subscriber;
        }

        @Override
        public TransactionalProcessorImpl<V> holder() {
            return this.holder;
        }

        @Override
        public void beginTransaction(V v) {
            this.active.set(v);
        }

        @Override
        public void commit() {
            Object v = this.active.getAndSet(null);
            if (v != null) {
                this.sub.submit(v);
            }
        }

        @Override
        public void rollback() {
            this.active.set(null);
        }

        @Override
        public void onClose() {
            this.sub.onClose();
        }

        @Override
        public void onError(Throwable throwable) {
            this.sub.onError(throwable);
        }
    }
}

