/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.serialize;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationOptions;
import us.ajg0702.queue.libs.sponge.configurate.serialize.SerializationException;
import us.ajg0702.queue.libs.sponge.configurate.serialize.TypeSerializer;
import us.ajg0702.queue.libs.sponge.configurate.util.CheckedConsumer;

public abstract class AbstractListChildSerializer<T>
implements TypeSerializer<T> {
    protected AbstractListChildSerializer() {
    }

    @Override
    public final T deserialize(Type type, ConfigurationNode configurationNode) {
        Type type2 = this.elementType(type);
        @Nullable TypeSerializer<?> typeSerializer = configurationNode.options().serializers().get(type2);
        if (typeSerializer == null) {
            throw new SerializationException(configurationNode, type2, "No applicable type serializer for type");
        }
        if (configurationNode.isList()) {
            List<? extends ConfigurationNode> list = configurationNode.childrenList();
            T t = this.createNew(list.size(), type2);
            for (int i = 0; i < list.size(); ++i) {
                try {
                    this.deserializeSingle(i, t, typeSerializer.deserialize(type2, list.get(i)));
                    continue;
                }
                catch (SerializationException serializationException) {
                    serializationException.initPath(list.get(i)::path);
                    throw serializationException;
                }
            }
            return t;
        }
        @Nullable Object object = configurationNode.raw();
        if (object != null) {
            T t = this.createNew(1, type2);
            this.deserializeSingle(0, t, typeSerializer.deserialize(type2, configurationNode));
            return t;
        }
        return this.createNew(0, type2);
    }

    @Override
    public final void serialize(Type type, @Nullable T t, ConfigurationNode configurationNode) {
        Type type2 = this.elementType(type);
        @Nullable TypeSerializer<?> typeSerializer = configurationNode.options().serializers().get(type2);
        if (typeSerializer == null) {
            throw new SerializationException(configurationNode, type2, "No applicable type serializer for type");
        }
        configurationNode.raw(Collections.emptyList());
        if (t != null) {
            this.forEachElement(t, object -> {
                ConfigurationNode configurationNode2 = configurationNode.appendListNode();
                try {
                    typeSerializer.serialize(type2, object, configurationNode2);
                }
                catch (SerializationException serializationException) {
                    serializationException.initPath(configurationNode2::path);
                    throw serializationException;
                }
            });
        }
    }

    @Override
    public @Nullable T emptyValue(Type type, ConfigurationOptions configurationOptions) {
        try {
            return this.createNew(0, this.elementType(type));
        }
        catch (SerializationException serializationException) {
            return null;
        }
    }

    protected abstract Type elementType(Type var1);

    protected abstract T createNew(int var1, Type var2);

    protected abstract void forEachElement(T var1, CheckedConsumer<Object, SerializationException> var2);

    protected abstract void deserializeSingle(int var1, T var2, @Nullable Object var3);
}

