/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.serialize;

import java.util.Locale;
import java.util.function.BiFunction;
import us.ajg0702.queue.libs.sponge.configurate.serialize.CoercionFailedException;
import us.ajg0702.queue.libs.sponge.configurate.serialize.ScalarSerializer;
import us.ajg0702.queue.libs.sponge.configurate.serialize.SerializationException;
import us.ajg0702.queue.libs.sponge.configurate.serialize.TypeSerializer;

final class NumericSerializers {
    private static final float EPSILON = Float.MIN_NORMAL;
    static final ScalarSerializer<Float> FLOAT = TypeSerializer.of(Float.class, (f, predicate) -> {
        if (predicate.test(Double.class)) {
            return f.doubleValue();
        }
        return f.toString();
    }, object -> {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (!NumericSerializers.canRepresentDoubleAsFloat(d)) {
                throw new SerializationException("Value " + d + " cannot be represented as a float without significant loss of precision");
            }
            return Float.valueOf((float)d);
        }
        if (object instanceof CharSequence) {
            String string = object.toString();
            if (string.endsWith("f") || string.endsWith("F")) {
                string = string.substring(0, string.length() - 1);
            }
            try {
                return Float.valueOf(Float.parseFloat(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SerializationException(numberFormatException);
            }
        }
        throw new CoercionFailedException(object, "float");
    });
    static final ScalarSerializer<Double> DOUBLE = TypeSerializer.of(Double.class, (d, predicate) -> d.toString(), object -> {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof CharSequence) {
            String string = object.toString();
            if (string.endsWith("d") || string.endsWith("D")) {
                string = string.substring(0, string.length() - 1);
            }
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SerializationException(numberFormatException);
            }
        }
        throw new CoercionFailedException(object, "double");
    });
    static final ScalarSerializer<Byte> BYTE = TypeSerializer.of(Byte.class, (by, predicate) -> {
        if (predicate.test(Short.class)) {
            return by.shortValue();
        }
        if (predicate.test(Integer.class)) {
            return by.intValue();
        }
        if (predicate.test(Double.class)) {
            return by.doubleValue();
        }
        if (predicate.test(Long.class)) {
            return by.longValue();
        }
        return by.toString();
    }, object -> {
        if (object instanceof Float || object instanceof Double) {
            double d = Math.abs(((Number)object).doubleValue());
            if (d - Math.floor(d) < 1.1754943508222875E-38 && d <= 127.0) {
                return (byte)d;
            }
            throw new CoercionFailedException(object, "byte");
        }
        if (object instanceof Number) {
            long l = ((Number)object).longValue();
            if (l > 127L || l < -128L) {
                throw new SerializationException("Value " + l + " is out of range for a byte ([" + -128 + "," + 127 + "])");
            }
            return (byte)l;
        }
        if (object instanceof CharSequence) {
            return NumericSerializers.parseNumber(object.toString(), Byte::parseByte, Byte::parseByte, "b");
        }
        throw new CoercionFailedException(object, "byte");
    });
    static final ScalarSerializer<Short> SHORT = TypeSerializer.of(Short.class, (s, predicate) -> {
        if (predicate.test(Integer.class)) {
            return s.intValue();
        }
        if (predicate.test(Long.class)) {
            return s.longValue();
        }
        if (predicate.test(Double.class)) {
            return s.doubleValue();
        }
        return s.toString();
    }, object -> {
        if (object instanceof Float || object instanceof Double) {
            double d = Math.abs(((Number)object).doubleValue());
            if (d - Math.floor(d) < 1.1754943508222875E-38 && d <= 32767.0) {
                return (short)d;
            }
            throw new CoercionFailedException(object, "short");
        }
        if (object instanceof Number) {
            long l = ((Number)object).longValue();
            if (l > 32767L || l < -32768L) {
                throw new SerializationException("Value " + l + " is out of range for a short ([" + Short.MIN_VALUE + "," + Short.MAX_VALUE + "])");
            }
            return (short)l;
        }
        if (object instanceof CharSequence) {
            return NumericSerializers.parseNumber(object.toString(), Short::parseShort, Short::parseShort, "s");
        }
        throw new CoercionFailedException(object, "short");
    });
    static final ScalarSerializer<Integer> INTEGER = TypeSerializer.of(Integer.class, (n, predicate) -> {
        if (predicate.test(Double.class)) {
            return n.doubleValue();
        }
        if (predicate.test(Long.class)) {
            return n.longValue();
        }
        return n.toString();
    }, object -> {
        if (object instanceof Float || object instanceof Double) {
            double d = Math.abs(((Number)object).doubleValue());
            if (d - Math.floor(d) < 1.1754943508222875E-38 && d <= 2.147483647E9) {
                return (int)d;
            }
            throw new CoercionFailedException(object, "int");
        }
        if (object instanceof Number) {
            long l = ((Number)object).longValue();
            if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                throw new SerializationException("Value " + l + " is out of range for an integer ([" + Integer.MIN_VALUE + "," + Integer.MAX_VALUE + "])");
            }
            return (int)l;
        }
        if (object instanceof CharSequence) {
            return NumericSerializers.parseNumber(object.toString(), Integer::parseInt, Integer::parseUnsignedInt, "i");
        }
        throw new CoercionFailedException(object, "int");
    });
    static final ScalarSerializer<Long> LONG = TypeSerializer.of(Long.class, (l, predicate) -> l.toString(), object -> {
        if (object instanceof Float || object instanceof Double) {
            double d = Math.abs(((Number)object).doubleValue());
            if (d - Math.floor(d) < 1.1754943508222875E-38 && d <= 9.223372036854776E18) {
                return (long)d;
            }
            throw new CoercionFailedException(object, "long");
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof CharSequence) {
            return NumericSerializers.parseNumber(object.toString(), Long::parseLong, Long::parseUnsignedLong, "l");
        }
        throw new CoercionFailedException(object, "long");
    });

    private NumericSerializers() {
    }

    private static boolean canRepresentDoubleAsFloat(double d) {
        if (d == 0.0 || d == -0.0 || !Double.isFinite(d)) {
            return true;
        }
        int n = Math.getExponent(d);
        return n >= -126 && n <= 127;
    }

    static <T extends Number> T parseNumber(String string, BiFunction<String, Integer, T> biFunction, BiFunction<String, Integer, T> biFunction2, String string2) {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = string.length();
        if (string.endsWith(string2) || string.endsWith(string2.toUpperCase(Locale.ROOT))) {
            --n2;
        }
        if (n2 > 0 && string.charAt(n2 - 1) == 'u') {
            bl = true;
            --n2;
        }
        if (n2 > n && string.charAt(n) == '-') {
            if (bl) {
                throw new SerializationException("Negative numbers cannot be unsigned! (both - prefix and u suffix were used)");
            }
            bl2 = true;
            ++n;
        } else if (n2 > n && string.charAt(n) == '+') {
            ++n;
        }
        int n3 = 10;
        if (string.startsWith("0x", n)) {
            n3 = 16;
            n += 2;
        } else if (string.length() > n && string.charAt(n) == '#') {
            n3 = 16;
            ++n;
        } else if (string.startsWith("0b", n)) {
            n3 = 2;
            n += 2;
        }
        string = string.substring(n, n2);
        if (bl2) {
            string = "-" + string;
        }
        try {
            return (T)((Number)(bl ? biFunction2 : biFunction).apply(string, n3));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SerializationException(illegalArgumentException);
        }
    }
}

