/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.serialize;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.geantyref.GenericTypeReflector;
import us.ajg0702.queue.libs.geantyref.TypeToken;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.objectmapping.ConfigSerializable;
import us.ajg0702.queue.libs.sponge.configurate.objectmapping.ObjectMapper;
import us.ajg0702.queue.libs.sponge.configurate.serialize.ArraySerializer;
import us.ajg0702.queue.libs.sponge.configurate.serialize.ConfigurationNodeSerializer;
import us.ajg0702.queue.libs.sponge.configurate.serialize.FileSerializer;
import us.ajg0702.queue.libs.sponge.configurate.serialize.ListSerializer;
import us.ajg0702.queue.libs.sponge.configurate.serialize.MapSerializer;
import us.ajg0702.queue.libs.sponge.configurate.serialize.PathSerializer;
import us.ajg0702.queue.libs.sponge.configurate.serialize.ScalarSerializer;
import us.ajg0702.queue.libs.sponge.configurate.serialize.Scalars;
import us.ajg0702.queue.libs.sponge.configurate.serialize.SetSerializer;
import us.ajg0702.queue.libs.sponge.configurate.serialize.TypeSerializer;
import us.ajg0702.queue.libs.sponge.configurate.util.Types;
import us.ajg0702.queue.libs.sponge.configurate.util.UnmodifiableCollections;

public final class TypeSerializerCollection {
    private static final TypeSerializerCollection DEFAULTS = TypeSerializerCollection.builder().registerExact(Scalars.STRING).registerExact(Scalars.BOOLEAN).register(MapSerializer.TYPE, new MapSerializer()).register(ListSerializer.TYPE, new ListSerializer()).registerExact(Scalars.BYTE).registerExact(Scalars.SHORT).registerExact(Scalars.INTEGER).registerExact(Scalars.LONG).registerExact(Scalars.FLOAT).registerExact(Scalars.DOUBLE).registerAnnotatedObjects(ObjectMapper.factory()).register(Scalars.ENUM).registerExact(Scalars.CHAR).registerExact(Scalars.URI).registerExact(Scalars.URL).registerExact(Scalars.UUID).registerExact(Scalars.PATTERN).register(ArraySerializer.Objects::accepts, new ArraySerializer.Objects()).registerExact(ArraySerializer.Booleans.TYPE, new ArraySerializer.Booleans()).registerExact(ArraySerializer.Bytes.TYPE, new ArraySerializer.Bytes()).registerExact(ArraySerializer.Chars.TYPE, new ArraySerializer.Chars()).registerExact(ArraySerializer.Shorts.TYPE, new ArraySerializer.Shorts()).registerExact(ArraySerializer.Ints.TYPE, new ArraySerializer.Ints()).registerExact(ArraySerializer.Longs.TYPE, new ArraySerializer.Longs()).registerExact(ArraySerializer.Floats.TYPE, new ArraySerializer.Floats()).registerExact(ArraySerializer.Doubles.TYPE, new ArraySerializer.Doubles()).register(SetSerializer::accepts, new SetSerializer()).register(ConfigurationNodeSerializer.TYPE, new ConfigurationNodeSerializer()).register(PathSerializer.TYPE, PathSerializer.INSTANCE).registerExact(FileSerializer.TYPE, FileSerializer.INSTANCE).build();
    private final @Nullable TypeSerializerCollection parent;
    final List<RegisteredSerializer> serializers;
    private final Map<Type, TypeSerializer<?>> typeMatches = new ConcurrentHashMap();

    private TypeSerializerCollection(@Nullable TypeSerializerCollection typeSerializerCollection, List<RegisteredSerializer> list) {
        this.parent = typeSerializerCollection;
        this.serializers = UnmodifiableCollections.copyOf(list);
    }

    public <T> @Nullable TypeSerializer<T> get(TypeToken<T> typeToken) {
        Objects.requireNonNull(typeToken, "type");
        return this.get0(typeToken.getType());
    }

    public <T> @Nullable TypeSerializer<T> get(Class<T> clazz) {
        Objects.requireNonNull(clazz, "type");
        Types.requireCompleteParameters(clazz);
        return this.get((Type)clazz);
    }

    public @Nullable TypeSerializer<?> get(Type type) {
        return this.get0(GenericTypeReflector.box(type));
    }

    private @Nullable TypeSerializer<?> get0(Type type2) {
        @Nullable TypeSerializer<?> typeSerializer = this.typeMatches.computeIfAbsent(type2, type -> {
            for (RegisteredSerializer registeredSerializer : this.serializers) {
                if (!registeredSerializer.predicate.test((Type)type)) continue;
                return registeredSerializer.serializer;
            }
            return NoOp.INSTANCE;
        });
        if (typeSerializer == NoOp.INSTANCE) {
            typeSerializer = null;
        }
        if (typeSerializer == null && this.parent != null) {
            typeSerializer = this.parent.get0(type2);
        }
        return typeSerializer;
    }

    public Builder childBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return "TypeSerializerCollection{parent=" + this.parent + ", serializers=" + this.serializers + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TypeSerializerCollection)) {
            return false;
        }
        TypeSerializerCollection typeSerializerCollection = (TypeSerializerCollection)object;
        return Objects.equals(this.parent, typeSerializerCollection.parent) && this.serializers.equals(typeSerializerCollection.serializers);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.serializers);
    }

    public static Builder builder() {
        return new Builder(null);
    }

    public static TypeSerializerCollection defaults() {
        return DEFAULTS;
    }

    static final class NoOp
    implements TypeSerializer<Void> {
        static final NoOp INSTANCE = new NoOp();

        private NoOp() {
        }

        @Override
        public Void deserialize(Type type, ConfigurationNode configurationNode) {
            throw new UnsupportedOperationException("this is a placeholder for null, should not be called directly");
        }

        @Override
        public void serialize(Type type, @Nullable Void void_, ConfigurationNode configurationNode) {
            throw new UnsupportedOperationException("this is a placeholder for null, should not be called directly");
        }
    }

    static final class RegisteredSerializer {
        final Predicate<Type> predicate;
        final TypeSerializer<?> serializer;

        private RegisteredSerializer(Predicate<Type> predicate, TypeSerializer<?> typeSerializer) {
            this.predicate = predicate;
            this.serializer = typeSerializer;
        }
    }

    public static class Builder {
        private final @Nullable TypeSerializerCollection parent;
        private final List<RegisteredSerializer> serializers = new ArrayList<RegisteredSerializer>();

        Builder(@Nullable TypeSerializerCollection typeSerializerCollection) {
            this.parent = typeSerializerCollection;
        }

        public <T> Builder register(TypeToken<T> typeToken, TypeSerializer<? super T> typeSerializer) {
            return this.register0(typeToken.getType(), typeSerializer);
        }

        public <T> Builder register(Class<T> clazz, TypeSerializer<? super T> typeSerializer) {
            return this.register0(clazz, typeSerializer);
        }

        public <T> Builder register(Predicate<Type> predicate, TypeSerializer<? super T> typeSerializer) {
            Objects.requireNonNull(predicate, "test");
            Objects.requireNonNull(typeSerializer, "serializer");
            this.serializers.add(new RegisteredSerializer(predicate, typeSerializer));
            return this;
        }

        public <T> Builder register(ScalarSerializer<T> scalarSerializer) {
            Objects.requireNonNull(scalarSerializer, "serializer");
            return this.register(scalarSerializer.type(), scalarSerializer);
        }

        private Builder register0(Type type, TypeSerializer<?> typeSerializer) {
            Objects.requireNonNull(type, "type");
            Objects.requireNonNull(typeSerializer, "serializer");
            this.serializers.add(new RegisteredSerializer(type2 -> {
                Type[] typeArray;
                if (GenericTypeReflector.isSuperType(type, type2)) {
                    return true;
                }
                if (type2 instanceof WildcardType && (typeArray = ((WildcardType)type2).getUpperBounds()).length == 1) {
                    return GenericTypeReflector.isSuperType(type, typeArray[0]);
                }
                return false;
            }, typeSerializer));
            return this;
        }

        public <T> Builder registerExact(TypeToken<T> typeToken, TypeSerializer<? super T> typeSerializer) {
            return this.registerExact0(typeToken.getType(), typeSerializer);
        }

        public <T> Builder registerExact(Class<T> clazz, TypeSerializer<? super T> typeSerializer) {
            return this.registerExact0(clazz, typeSerializer);
        }

        public <T> Builder registerExact(ScalarSerializer<T> scalarSerializer) {
            Objects.requireNonNull(scalarSerializer, "serializer");
            return this.registerExact(scalarSerializer.type(), scalarSerializer);
        }

        private Builder registerExact0(Type type, TypeSerializer<?> typeSerializer) {
            Objects.requireNonNull(type, "type");
            Objects.requireNonNull(typeSerializer, "serializer");
            this.serializers.add(new RegisteredSerializer(type2 -> type2.equals(type), typeSerializer));
            return this;
        }

        public Builder registerAll(TypeSerializerCollection typeSerializerCollection) {
            this.serializers.addAll(Objects.requireNonNull(typeSerializerCollection, (String)"other").serializers);
            return this;
        }

        public Builder registerAnnotatedObjects(ObjectMapper.Factory factory) {
            return this.register(Builder::isAnnotatedTarget, factory.asTypeSerializer());
        }

        static boolean isAnnotatedTarget(Type type) {
            return GenericTypeReflector.annotate(type).isAnnotationPresent(ConfigSerializable.class);
        }

        public TypeSerializerCollection build() {
            return new TypeSerializerCollection(this.parent, this.serializers);
        }
    }
}

