/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.transformation;

import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurateException;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.transformation.ConfigurationTransformation;

class ChainedConfigurationTransformation
implements ConfigurationTransformation {
    private final ConfigurationTransformation[] transformations;

    ChainedConfigurationTransformation(ConfigurationTransformation[] configurationTransformationArray) {
        this.transformations = Arrays.copyOf(configurationTransformationArray, configurationTransformationArray.length);
    }

    @Override
    public void apply(ConfigurationNode configurationNode) {
        @Nullable ConfigurateException configurateException = null;
        for (ConfigurationTransformation configurationTransformation : this.transformations) {
            try {
                configurationTransformation.apply(configurationNode);
            }
            catch (ConfigurateException configurateException2) {
                if (configurateException == null) {
                    configurateException = configurateException2;
                    continue;
                }
                configurateException.addSuppressed(configurateException2);
            }
        }
        if (configurateException != null) {
            throw configurateException;
        }
    }
}

