/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.transformation;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurateException;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.NodePath;
import us.ajg0702.queue.libs.sponge.configurate.transformation.ConfigurationTransformation;
import us.ajg0702.queue.libs.sponge.configurate.transformation.MoveStrategy;
import us.ajg0702.queue.libs.sponge.configurate.transformation.MutableNodePath;
import us.ajg0702.queue.libs.sponge.configurate.transformation.TransformAction;

final class SingleConfigurationTransformation
implements ConfigurationTransformation {
    private final MoveStrategy strategy;
    private final Map<NodePath, TransformAction> actions;
    private final ThreadLocal<MutableNodePath> sharedPath = ThreadLocal.withInitial(MutableNodePath::new);

    SingleConfigurationTransformation(Map<NodePath, TransformAction> map, MoveStrategy moveStrategy) {
        this.actions = map;
        this.strategy = moveStrategy;
    }

    @Override
    public void apply(ConfigurationNode configurationNode) {
        @Nullable ConfigurateException configurateException = null;
        for (Map.Entry<NodePath, TransformAction> entry : this.actions.entrySet()) {
            try {
                this.applySingleAction(configurationNode, entry.getKey().array(), 0, configurationNode, entry.getValue());
            }
            catch (ConfigurateException configurateException2) {
                if (configurateException == null) {
                    configurateException = configurateException2;
                    continue;
                }
                configurateException.addSuppressed(configurateException2);
            }
        }
        if (configurateException != null) {
            throw configurateException;
        }
    }

    private void applySingleAction(ConfigurationNode configurationNode, Object[] objectArray, int n, ConfigurationNode configurationNode2, TransformAction transformAction) {
        ConfigurateException configurateException = null;
        for (int i = n; i < objectArray.length; ++i) {
            if (objectArray[i] == WILDCARD_OBJECT) {
                if (configurationNode2.isList()) {
                    List<? extends ConfigurationNode> list = configurationNode2.childrenList();
                    for (int j = 0; j < list.size(); ++j) {
                        objectArray[i] = j;
                        try {
                            this.applySingleAction(configurationNode, objectArray, i + 1, list.get(j), transformAction);
                            continue;
                        }
                        catch (ConfigurateException configurateException2) {
                            if (configurateException == null) {
                                configurateException = configurateException2;
                                continue;
                            }
                            configurateException.addSuppressed(configurateException2);
                        }
                    }
                    objectArray[i] = WILDCARD_OBJECT;
                } else if (configurationNode2.isMap()) {
                    for (Map.Entry<Object, ? extends ConfigurationNode> entry : configurationNode2.childrenMap().entrySet()) {
                        objectArray[i] = entry.getKey();
                        try {
                            this.applySingleAction(configurationNode, objectArray, i + 1, entry.getValue(), transformAction);
                        }
                        catch (ConfigurateException configurateException3) {
                            if (configurateException == null) {
                                configurateException = configurateException3;
                                continue;
                            }
                            configurateException.addSuppressed(configurateException3);
                        }
                    }
                    objectArray[i] = WILDCARD_OBJECT;
                } else {
                    return;
                }
                return;
            }
            if (!(configurationNode2 = configurationNode2.node(objectArray[i])).virtual()) continue;
            return;
        }
        MutableNodePath mutableNodePath = this.sharedPath.get();
        mutableNodePath.arr = objectArray;
        Object @Nullable [] objectArray2 = transformAction.visitPath(mutableNodePath, configurationNode2);
        if (objectArray2 != null && !Arrays.equals(objectArray, objectArray2)) {
            this.strategy.move(configurationNode2, configurationNode.node(objectArray2));
            configurationNode2.raw(null);
        }
    }
}

