/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.utils.bungee;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class BungeeStats {
    public static final int B_STATS_VERSION = 1;
    private static final String URL = "https://bStats.org/submitData/bungeecord";
    private final Plugin plugin;
    private final int pluginId;
    private boolean enabled;
    private String serverUUID;
    private boolean logFailedRequests;
    private static boolean logSentData;
    private static boolean logResponseStatusText;
    private static final List<Object> knownMetricsInstances;
    private final List<CustomChart> charts;

    public BungeeStats(Plugin plugin, int n) {
        block8: {
            this.logFailedRequests = false;
            this.charts = new ArrayList<CustomChart>();
            this.plugin = plugin;
            this.pluginId = n;
            try {
                this.loadConfig();
            }
            catch (IOException iOException) {
                plugin.getLogger().log(Level.WARNING, "Failed to load bStats config!", iOException);
                return;
            }
            if (!this.enabled) {
                return;
            }
            Class<?> clazz = this.getFirstBStatsClass();
            if (clazz == null) {
                return;
            }
            if (clazz == this.getClass()) {
                BungeeStats.linkMetrics(this);
                this.startSubmitting();
            } else {
                try {
                    clazz.getMethod("linkMetrics", Object.class).invoke(null, this);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    if (!this.logFailedRequests) break block8;
                    plugin.getLogger().log(Level.WARNING, "Failed to link to first metrics class " + clazz.getName() + "!", reflectiveOperationException);
                }
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void addCustomChart(CustomChart customChart) {
        if (customChart == null) {
            this.plugin.getLogger().log(Level.WARNING, "Chart cannot be null");
        }
        this.charts.add(customChart);
    }

    public static void linkMetrics(Object object) {
        knownMetricsInstances.add(object);
    }

    public JsonObject getPluginData() {
        JsonObject jsonObject = new JsonObject();
        String string = this.plugin.getDescription().getName();
        String string2 = this.plugin.getDescription().getVersion();
        jsonObject.addProperty("pluginName", string);
        jsonObject.addProperty("id", (Number)this.pluginId);
        jsonObject.addProperty("pluginVersion", string2);
        JsonArray jsonArray = new JsonArray();
        for (CustomChart customChart : this.charts) {
            JsonObject jsonObject2 = customChart.getRequestJsonObject(this.plugin.getLogger(), this.logFailedRequests);
            if (jsonObject2 == null) continue;
            jsonArray.add((JsonElement)jsonObject2);
        }
        jsonObject.add("customCharts", (JsonElement)jsonArray);
        return jsonObject;
    }

    private void startSubmitting() {
        this.plugin.getProxy().getScheduler().schedule(this.plugin, this::submitData, 2L, 30L, TimeUnit.MINUTES);
    }

    private JsonObject getServerData() {
        int n = Math.min(this.plugin.getProxy().getOnlineCount(), 500);
        int n2 = this.plugin.getProxy().getConfig().isOnlineMode() ? 1 : 0;
        String string = this.plugin.getProxy().getVersion();
        int n3 = this.plugin.getProxy().getServers().size();
        String string2 = System.getProperty("java.version");
        String string3 = System.getProperty("os.name");
        String string4 = System.getProperty("os.arch");
        String string5 = System.getProperty("os.version");
        int n4 = Runtime.getRuntime().availableProcessors();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("serverUUID", this.serverUUID);
        jsonObject.addProperty("playerAmount", (Number)n);
        jsonObject.addProperty("managedServers", (Number)n3);
        jsonObject.addProperty("onlineMode", (Number)n2);
        jsonObject.addProperty("bungeecordVersion", string);
        jsonObject.addProperty("javaVersion", string2);
        jsonObject.addProperty("osName", string3);
        jsonObject.addProperty("osArch", string4);
        jsonObject.addProperty("osVersion", string5);
        jsonObject.addProperty("coreCount", (Number)n4);
        return jsonObject;
    }

    private void submitData() {
        block5: {
            JsonObject jsonObject = this.getServerData();
            JsonArray jsonArray = new JsonArray();
            for (Object object : knownMetricsInstances) {
                try {
                    Object object2 = object.getClass().getMethod("getPluginData", new Class[0]).invoke(object, new Object[0]);
                    if (!(object2 instanceof JsonObject)) continue;
                    jsonArray.add((JsonElement)((JsonObject)object2));
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {}
            }
            jsonObject.add("plugins", (JsonElement)jsonArray);
            try {
                BungeeStats.sendData(this.plugin, jsonObject);
            }
            catch (Exception exception) {
                if (!this.logFailedRequests) break block5;
                this.plugin.getLogger().log(Level.WARNING, "Could not submit plugin stats!", exception);
            }
        }
    }

    private void loadConfig() {
        File file = new File(this.plugin.getDataFolder().getParentFile(), "bStats");
        file.mkdirs();
        File file2 = new File(file, "config.yml");
        if (!file2.exists()) {
            this.writeFile(file2, "#bStats collects some data for plugin authors like how many servers are using their plugins.", "#To honor their work, you should not disable it.", "#This has nearly no effect on the server performance!", "#Check out https://bStats.org/ to learn more :)", "enabled: true", "serverUuid: \"" + UUID.randomUUID() + "\"", "logFailedRequests: false", "logSentData: false", "logResponseStatusText: false");
        }
        Configuration configuration = ConfigurationProvider.getProvider(YamlConfiguration.class).load(file2);
        this.enabled = configuration.getBoolean("enabled", true);
        this.serverUUID = configuration.getString("serverUuid");
        this.logFailedRequests = configuration.getBoolean("logFailedRequests", false);
        logSentData = configuration.getBoolean("logSentData", false);
        logResponseStatusText = configuration.getBoolean("logResponseStatusText", false);
    }

    private Class<?> getFirstBStatsClass() {
        File file = new File(this.plugin.getDataFolder().getParentFile(), "bStats");
        file.mkdirs();
        File file2 = new File(file, "temp.txt");
        try {
            String string = this.readFile(file2);
            if (string != null) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            this.writeFile(file2, this.getClass().getName());
            return this.getClass();
        }
        catch (IOException iOException) {
            if (this.logFailedRequests) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to get first bStats class!", iOException);
            }
            return null;
        }
    }

    private String readFile(File file) {
        if (!file.exists()) {
            return null;
        }
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String string = bufferedReader.readLine();
            return string;
        }
    }

    private void writeFile(File file, String ... stringArray) {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
            for (String string : stringArray) {
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
        }
    }

    private static void sendData(Plugin plugin, JsonObject jsonObject) {
        if (jsonObject == null) {
            throw new IllegalArgumentException("Data cannot be null");
        }
        if (logSentData) {
            plugin.getLogger().info("Sending data to bStats: " + jsonObject);
        }
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)new URL(URL).openConnection();
        byte[] byArray = BungeeStats.compress(jsonObject.toString());
        httpsURLConnection.setRequestMethod("POST");
        httpsURLConnection.addRequestProperty("Accept", "application/json");
        httpsURLConnection.addRequestProperty("Connection", "close");
        httpsURLConnection.addRequestProperty("Content-Encoding", "gzip");
        httpsURLConnection.addRequestProperty("Content-Length", String.valueOf(byArray.length));
        httpsURLConnection.setRequestProperty("Content-Type", "application/json");
        httpsURLConnection.setRequestProperty("User-Agent", "MC-Server/1");
        httpsURLConnection.setDoOutput(true);
        Object object = new DataOutputStream(httpsURLConnection.getOutputStream());
        Object object2 = null;
        try {
            ((FilterOutputStream)object).write(byArray);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        ((FilterOutputStream)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ((FilterOutputStream)object).close();
                }
            }
        }
        object = new StringBuilder();
        object2 = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));
        Throwable throwable = null;
        try {
            String string;
            while ((string = ((BufferedReader)object2).readLine()) != null) {
                ((StringBuilder)object).append(string);
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (object2 != null) {
                if (throwable != null) {
                    try {
                        ((BufferedReader)object2).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    ((BufferedReader)object2).close();
                }
            }
        }
        if (logResponseStatusText) {
            plugin.getLogger().info("Sent data to bStats and received response: " + object);
        }
    }

    private static byte[] compress(String string) {
        if (string == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
            gZIPOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
        }
        return byteArrayOutputStream.toByteArray();
    }

    static {
        if (System.getProperty("bstats.relocatecheck") == null || !System.getProperty("bstats.relocatecheck").equals("false")) {
            String string = new String(new byte[]{111, 114, 103, 46, 98, 115, 116, 97, 116, 115, 46, 98, 117, 110, 103, 101, 101, 99, 111, 114, 100});
            String string2 = new String(new byte[]{121, 111, 117, 114, 46, 112, 97, 99, 107, 97, 103, 101});
            if (BungeeStats.class.getPackage().getName().equals(string) || BungeeStats.class.getPackage().getName().equals(string2)) {
                throw new IllegalStateException("bStats Metrics class has not been relocated correctly!");
            }
        }
        knownMetricsInstances = new ArrayList<Object>();
    }

    public static class AdvancedBarChart
    extends CustomChart {
        private final Callable<Map<String, int[]>> callable;

        public AdvancedBarChart(String string, Callable<Map<String, int[]>> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        protected JsonObject getChartData() {
            JsonObject jsonObject = new JsonObject();
            JsonObject jsonObject2 = new JsonObject();
            Map<String, int[]> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean bl = true;
            for (Map.Entry<String, int[]> entry : map.entrySet()) {
                if (entry.getValue().length == 0) continue;
                bl = false;
                JsonArray jsonArray = new JsonArray();
                for (int n : entry.getValue()) {
                    jsonArray.add((JsonElement)new JsonPrimitive((Number)n));
                }
                jsonObject2.add(entry.getKey(), (JsonElement)jsonArray);
            }
            if (bl) {
                return null;
            }
            jsonObject.add("values", (JsonElement)jsonObject2);
            return jsonObject;
        }
    }

    public static class SimpleBarChart
    extends CustomChart {
        private final Callable<Map<String, Integer>> callable;

        public SimpleBarChart(String string, Callable<Map<String, Integer>> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        protected JsonObject getChartData() {
            JsonObject jsonObject = new JsonObject();
            JsonObject jsonObject2 = new JsonObject();
            Map<String, Integer> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                JsonArray jsonArray = new JsonArray();
                jsonArray.add((JsonElement)new JsonPrimitive((Number)entry.getValue()));
                jsonObject2.add(entry.getKey(), (JsonElement)jsonArray);
            }
            jsonObject.add("values", (JsonElement)jsonObject2);
            return jsonObject;
        }
    }

    public static class MultiLineChart
    extends CustomChart {
        private final Callable<Map<String, Integer>> callable;

        public MultiLineChart(String string, Callable<Map<String, Integer>> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        protected JsonObject getChartData() {
            JsonObject jsonObject = new JsonObject();
            JsonObject jsonObject2 = new JsonObject();
            Map<String, Integer> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean bl = true;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                if (entry.getValue() == 0) continue;
                bl = false;
                jsonObject2.addProperty(entry.getKey(), (Number)entry.getValue());
            }
            if (bl) {
                return null;
            }
            jsonObject.add("values", (JsonElement)jsonObject2);
            return jsonObject;
        }
    }

    public static class SingleLineChart
    extends CustomChart {
        private final Callable<Integer> callable;

        public SingleLineChart(String string, Callable<Integer> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        protected JsonObject getChartData() {
            JsonObject jsonObject = new JsonObject();
            int n = this.callable.call();
            if (n == 0) {
                return null;
            }
            jsonObject.addProperty("value", (Number)n);
            return jsonObject;
        }
    }

    public static class DrilldownPie
    extends CustomChart {
        private final Callable<Map<String, Map<String, Integer>>> callable;

        public DrilldownPie(String string, Callable<Map<String, Map<String, Integer>>> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        public JsonObject getChartData() {
            JsonObject jsonObject = new JsonObject();
            JsonObject jsonObject2 = new JsonObject();
            Map<String, Map<String, Integer>> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean bl = true;
            for (Map.Entry<String, Map<String, Integer>> entry : map.entrySet()) {
                JsonObject jsonObject3 = new JsonObject();
                boolean bl2 = true;
                for (Map.Entry<String, Integer> entry2 : map.get(entry.getKey()).entrySet()) {
                    jsonObject3.addProperty(entry2.getKey(), (Number)entry2.getValue());
                    bl2 = false;
                }
                if (bl2) continue;
                bl = false;
                jsonObject2.add(entry.getKey(), (JsonElement)jsonObject3);
            }
            if (bl) {
                return null;
            }
            jsonObject.add("values", (JsonElement)jsonObject2);
            return jsonObject;
        }
    }

    public static class AdvancedPie
    extends CustomChart {
        private final Callable<Map<String, Integer>> callable;

        public AdvancedPie(String string, Callable<Map<String, Integer>> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        protected JsonObject getChartData() {
            JsonObject jsonObject = new JsonObject();
            JsonObject jsonObject2 = new JsonObject();
            Map<String, Integer> map = this.callable.call();
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean bl = true;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                if (entry.getValue() == 0) continue;
                bl = false;
                jsonObject2.addProperty(entry.getKey(), (Number)entry.getValue());
            }
            if (bl) {
                return null;
            }
            jsonObject.add("values", (JsonElement)jsonObject2);
            return jsonObject;
        }
    }

    public static class SimplePie
    extends CustomChart {
        private final Callable<String> callable;

        public SimplePie(String string, Callable<String> callable) {
            super(string);
            this.callable = callable;
        }

        @Override
        protected JsonObject getChartData() {
            JsonObject jsonObject = new JsonObject();
            String string = this.callable.call();
            if (string == null || string.isEmpty()) {
                return null;
            }
            jsonObject.addProperty("value", string);
            return jsonObject;
        }
    }

    public static abstract class CustomChart {
        private final String chartId;

        CustomChart(String string) {
            if (string == null || string.isEmpty()) {
                throw new IllegalArgumentException("ChartId cannot be null or empty!");
            }
            this.chartId = string;
        }

        private JsonObject getRequestJsonObject(Logger logger, boolean bl) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("chartId", this.chartId);
            try {
                JsonObject jsonObject2 = this.getChartData();
                if (jsonObject2 == null) {
                    return null;
                }
                jsonObject.add("data", (JsonElement)jsonObject2);
            }
            catch (Throwable throwable) {
                if (bl) {
                    logger.log(Level.WARNING, "Failed to get data for custom chart with id " + this.chartId, throwable);
                }
                return null;
            }
            return jsonObject;
        }

        protected abstract JsonObject getChartData();
    }
}

