/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.logic;

import com.google.common.collect.ImmutableList;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.players.QueuePlayer;
import us.ajg0702.queue.api.premium.Logic;
import us.ajg0702.queue.api.premium.PermissionGetter;
import us.ajg0702.queue.api.queues.QueueServer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.api.util.QueueLogger;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.common.players.QueuePlayerImpl;
import us.ajg0702.queue.logic.permissions.PermissionGetterImpl;

public class PremiumLogic
implements Logic {
    private final PermissionGetter permissionGetter;

    @Override
    public PermissionGetter getPermissionGetter() {
        return this.permissionGetter;
    }

    public PremiumLogic(QueueMain queueMain) {
        this.permissionGetter = new PermissionGetterImpl(queueMain);
    }

    @Override
    public boolean isPremium() {
        return true;
    }

    @Override
    public QueuePlayer priorityLogic(QueueServer queueServer, AdaptedPlayer adaptedPlayer, AdaptedServer adaptedServer) {
        int n = this.permissionGetter.getMaxOfflineTime(adaptedPlayer);
        QueueMain queueMain = QueueMain.getInstance();
        QueueLogger queueLogger = queueMain.getLogger();
        boolean bl = queueMain.getConfig().getBoolean("priority-queue-debug");
        if (this.hasAnyBypass(adaptedPlayer, queueServer.getName())) {
            if (bl) {
                queueLogger.info("[priority] " + adaptedPlayer.getName() + " bypass");
            }
            QueuePlayerImpl queuePlayerImpl = new QueuePlayerImpl(adaptedPlayer, queueServer, Integer.MAX_VALUE, n);
            queueServer.addPlayer(queuePlayerImpl, 0);
            queueMain.getQueueManager().sendPlayers(queueServer);
            return queuePlayerImpl;
        }
        int n2 = this.permissionGetter.getPriority(adaptedPlayer);
        int n3 = this.permissionGetter.getServerPriotity(queueServer.getName(), adaptedPlayer);
        if (bl) {
            queueLogger.info("[priority] Using " + this.permissionGetter.getSelected().getName() + " for permissions");
        }
        int n4 = Math.max(n2, n3);
        n4 = Math.max(n4, Logic.getUnJoinablePriorities(queueServer, adaptedServer, adaptedPlayer));
        QueuePlayerImpl queuePlayerImpl = new QueuePlayerImpl(adaptedPlayer, queueServer, n4, n);
        if (bl) {
            queueLogger.info("[priority] " + adaptedPlayer.getName() + " highestPriority: " + n4);
            queueLogger.info("[priority] " + adaptedPlayer.getName() + "   priority: " + n2);
            queueLogger.info("[priority] " + adaptedPlayer.getName() + "   serverPriority: " + n3);
        }
        if (n4 <= 0) {
            if (bl) {
                queueLogger.info("[priority] " + adaptedPlayer.getName() + "  No priority");
            }
            queueServer.addPlayer(queuePlayerImpl);
            return queuePlayerImpl;
        }
        ImmutableList<QueuePlayer> immutableList = queueServer.getQueue();
        for (int i = 0; i < immutableList.size(); ++i) {
            QueuePlayer queuePlayer = (QueuePlayer)immutableList.get(i);
            if (queuePlayer.getPriority() >= n4) continue;
            if (bl) {
                queueLogger.info("[priority] " + adaptedPlayer.getName() + "  Adding to: " + i);
            }
            queueServer.addPlayer(queuePlayerImpl, i);
            return queuePlayerImpl;
        }
        if (bl) {
            queueLogger.info("[priority] " + adaptedPlayer.getName() + "  Cant go infront of anyone");
        }
        queueServer.addPlayer(queuePlayerImpl);
        return queuePlayerImpl;
    }

    @Override
    public boolean playerDisconnectedTooLong(QueuePlayer queuePlayer) {
        return queuePlayer.getTimeSinceOnline() > (long)queuePlayer.getMaxOfflineTime() * 1000L;
    }

    @Override
    public boolean hasAnyBypass(AdaptedPlayer adaptedPlayer, String string) {
        return adaptedPlayer.hasPermission("ajqueue.bypass") || adaptedPlayer.hasPermission("ajqueue.serverbypass." + string) || adaptedPlayer.hasPermission("ajqueue.joinfullandbypassserver." + string) || adaptedPlayer.hasPermission("ajqueue.joinfullandbypass") || this.permissionGetter.hasContextBypass(adaptedPlayer, string) || QueueMain.getInstance().isPremium() && this.permissionGetter.hasUniqueFullBypass(adaptedPlayer, string);
    }
}

