/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.logic.permissions.hooks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.context.Context;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.query.QueryOptions;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.premium.PermissionHook;
import us.ajg0702.queue.common.QueueMain;

public class LuckPermsHook
implements PermissionHook {
    private final QueueMain main;

    public LuckPermsHook(QueueMain queueMain) {
        this.main = queueMain;
    }

    @Override
    public String getName() {
        return "LuckPerms";
    }

    @Override
    public boolean canUse() {
        return this.main.getPlatformMethods().hasPlugin("LuckPerms");
    }

    @Override
    public List<String> getPermissions(AdaptedPlayer adaptedPlayer) {
        LuckPerms luckPerms = LuckPermsProvider.get();
        User user = luckPerms.getUserManager().getUser(adaptedPlayer.getUniqueId());
        if (user == null) {
            this.main.getLogger().warn("LuckPerms doesnt seem to have data loaded for " + adaptedPlayer.getName() + "! Because of this I can't load priority permissions. Acting like " + adaptedPlayer.getName() + " doesnt have any.");
            return Collections.emptyList();
        }
        SortedSet sortedSet = user.resolveDistinctInheritedNodes(QueryOptions.nonContextual());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Node node : sortedSet) {
            boolean bl;
            if (!node.getType().equals(NodeType.PERMISSION) || !node.getValue()) continue;
            String string = node.getKey();
            if (string.equalsIgnoreCase("ajqueue.contextbypass")) {
                bl = false;
                for (Object object : node.getContexts()) {
                    if (!object.getKey().equalsIgnoreCase("server")) continue;
                    bl = true;
                    arrayList.add("ajqueue.serverbypass." + object.getValue());
                }
                if (bl) continue;
            }
            if (string.toLowerCase(Locale.ROOT).startsWith("ajqueue.contextpriority.")) {
                int n;
                Object object;
                bl = false;
                try {
                    n = Integer.parseInt(string.substring(0, 24));
                }
                catch (NumberFormatException numberFormatException) {
                    this.main.getLogger().warning("A non-number is in the priority permission " + string);
                    continue;
                }
                object = node.getContexts().iterator();
                while (object.hasNext()) {
                    Context context = (Context)object.next();
                    if (!context.getKey().equalsIgnoreCase("server")) continue;
                    bl = true;
                    arrayList.add("ajqueue.serverpriority." + context.getValue() + "." + n);
                }
                if (bl) continue;
            }
            arrayList.add(string);
        }
        return arrayList;
    }
}

