/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.platforms.bungeecord;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import us.ajg0702.queue.api.PlatformMethods;
import us.ajg0702.queue.api.commands.IBaseCommand;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.api.util.QueueLogger;
import us.ajg0702.queue.commands.commands.PlayerSender;
import us.ajg0702.queue.platforms.bungeecord.BungeeQueue;
import us.ajg0702.queue.platforms.bungeecord.players.BungeePlayer;
import us.ajg0702.queue.platforms.bungeecord.server.BungeeServer;

public class BungeeMethods
implements PlatformMethods {
    final ProxyServer proxyServer;
    final QueueLogger logger;
    final BungeeQueue plugin;
    List<BungeeServer> serverList = new ArrayList<BungeeServer>();

    public BungeeMethods(BungeeQueue bungeeQueue, ProxyServer proxyServer, QueueLogger queueLogger) {
        this.proxyServer = proxyServer;
        this.logger = queueLogger;
        this.plugin = bungeeQueue;
    }

    @Override
    public void sendPluginMessage(AdaptedPlayer adaptedPlayer, String string, String ... proxiedPlayer) {
        Collection collection = ProxyServer.getInstance().getPlayers();
        if (collection != null && !collection.isEmpty()) {
            String string2 = adaptedPlayer.getName();
            if (string2 == null) {
                return;
            }
            ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
            byteArrayDataOutput.writeUTF(string);
            for (String string3 : proxiedPlayer) {
                byteArrayDataOutput.writeUTF(string3);
            }
            ProxiedPlayer proxiedPlayer2 = ((BungeePlayer)adaptedPlayer).getHandle();
            if (proxiedPlayer2 == null) {
                return;
            }
            Server server = proxiedPlayer2.getServer();
            if (server == null) {
                return;
            }
            server.sendData("ajqueue:tospigot", byteArrayDataOutput.toByteArray());
        }
    }

    @Override
    public AdaptedPlayer senderToPlayer(ICommandSender iCommandSender) {
        if (iCommandSender instanceof PlayerSender) {
            return ((PlayerSender)iCommandSender).getHandle();
        }
        return new BungeePlayer((ProxiedPlayer)iCommandSender.getHandle());
    }

    @Override
    public String getPluginVersion() {
        return this.plugin.getDescription().getVersion();
    }

    @Override
    public List<AdaptedPlayer> getOnlinePlayers() {
        ArrayList<AdaptedPlayer> arrayList = new ArrayList<AdaptedPlayer>();
        this.proxyServer.getPlayers().forEach(proxiedPlayer -> arrayList.add(new BungeePlayer((ProxiedPlayer)proxiedPlayer)));
        return arrayList;
    }

    @Override
    public List<String> getPlayerNames(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.proxyServer.getPlayers().forEach(proxiedPlayer -> arrayList.add(bl ? proxiedPlayer.getName().toLowerCase(Locale.ROOT) : proxiedPlayer.getName()));
        return arrayList;
    }

    @Override
    public AdaptedPlayer getPlayer(String string) {
        ProxiedPlayer proxiedPlayer = this.proxyServer.getPlayer(string);
        if (proxiedPlayer == null) {
            return null;
        }
        return new BungeePlayer(proxiedPlayer);
    }

    @Override
    public AdaptedPlayer getPlayer(UUID uUID) {
        ProxiedPlayer proxiedPlayer = this.proxyServer.getPlayer(uUID);
        if (proxiedPlayer == null) {
            return null;
        }
        return new BungeePlayer(proxiedPlayer);
    }

    @Override
    public List<String> getServerNames() {
        return new ArrayList<String>(this.proxyServer.getServers().keySet());
    }

    @Override
    public String getImplementationName() {
        return "BungeeCord";
    }

    @Override
    public List<IBaseCommand> getCommands() {
        return this.plugin.commands;
    }

    @Override
    public boolean hasPlugin(String string) {
        return this.proxyServer.getPluginManager().getPlugin(string) != null;
    }

    @Override
    public AdaptedServer getServer(String string) {
        List<? extends AdaptedServer> list = this.getServers();
        for (AdaptedServer adaptedServer : list) {
            if (!adaptedServer.getName().equals(string)) continue;
            return adaptedServer;
        }
        return null;
    }

    @Override
    public List<? extends AdaptedServer> getServers() {
        boolean bl;
        for (ServerInfo object : this.proxyServer.getServers().values()) {
            bl = false;
            for (BungeeServer bungeeServer2 : new ArrayList<BungeeServer>(this.serverList)) {
                if (!bungeeServer2.getHandle().equals(object) || !bungeeServer2.getName().equals(object.getName())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.serverList.add(new BungeeServer(object));
        }
        for (BungeeServer bungeeServer : new ArrayList<BungeeServer>(this.serverList)) {
            bl = false;
            for (BungeeServer bungeeServer2 : this.proxyServer.getServers().values()) {
                if (!bungeeServer.getHandle().equals(bungeeServer2) || !bungeeServer.getName().equals(bungeeServer2.getName())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.serverList.remove(bungeeServer);
        }
        return this.serverList;
    }

    @Override
    public String getProtocolName(int n) {
        return n + "";
    }
}

