/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.platforms.bungeecord;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.platform.bungeecord.BungeeAudiences;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.ServerKickEvent;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;
import org.checkerframework.checker.nullness.qual.NonNull;
import us.ajg0702.queue.api.Implementation;
import us.ajg0702.queue.api.commands.IBaseCommand;
import us.ajg0702.queue.commands.BaseCommand;
import us.ajg0702.queue.commands.commands.leavequeue.LeaveCommand;
import us.ajg0702.queue.commands.commands.listqueues.ListCommand;
import us.ajg0702.queue.commands.commands.manage.ManageCommand;
import us.ajg0702.queue.commands.commands.queue.QueueCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.bstats.bungeecord.Metrics;
import us.ajg0702.queue.libs.bstats.charts.SimplePie;
import us.ajg0702.queue.platforms.bungeecord.BungeeLogger;
import us.ajg0702.queue.platforms.bungeecord.BungeeMethods;
import us.ajg0702.queue.platforms.bungeecord.commands.BungeeCommand;
import us.ajg0702.queue.platforms.bungeecord.players.BungeePlayer;
import us.ajg0702.queue.platforms.bungeecord.server.BungeeServer;

public class BungeeQueue
extends Plugin
implements Listener,
Implementation {
    private QueueMain main;
    List<IBaseCommand> commands;
    Map<String, BungeeCommand> commandMap;
    private static BungeeAudiences adventure;

    public void onEnable() {
        BungeeLogger bungeeLogger = new BungeeLogger(this.getLogger());
        File file = this.getDataFolder();
        this.commandMap = new HashMap<String, BungeeCommand>();
        adventure = BungeeAudiences.create(this);
        this.main = new QueueMain(this, bungeeLogger, new BungeeMethods(this, this.getProxy(), bungeeLogger), file);
        this.getProxy().registerChannel("ajqueue:tospigot");
        this.getProxy().registerChannel("ajqueue:toproxy");
        this.commands = Arrays.asList(new QueueCommand(this.main), new LeaveCommand(this.main), new ListCommand(this.main), new ManageCommand(this.main));
        for (IBaseCommand iBaseCommand : this.commands) {
            this.registerCommand(iBaseCommand);
        }
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)this);
        Metrics metrics = new Metrics(this, 7404);
        metrics.addCustomChart(new SimplePie("premium", () -> String.valueOf(this.main.getLogic().isPremium())));
        metrics.addCustomChart(new SimplePie("implementation", () -> this.main.getPlatformMethods().getImplementationName()));
    }

    public static @NonNull BungeeAudiences adventure() {
        if (adventure == null) {
            throw new IllegalStateException("Cannot retrieve audience provider. Not loaded yet.");
        }
        return adventure;
    }

    public void onDisable() {
        this.main.shutdown();
        if (adventure != null) {
            adventure.close();
            adventure = null;
        }
    }

    @EventHandler
    public void onPluginMessage(PluginMessageEvent pluginMessageEvent) {
        if (pluginMessageEvent.getTag().equals("ajqueue:tospigot")) {
            pluginMessageEvent.setCancelled(true);
            return;
        }
        if (!pluginMessageEvent.getTag().equals("ajqueue:toproxy")) {
            return;
        }
        pluginMessageEvent.setCancelled(true);
        if (!(pluginMessageEvent.getReceiver() instanceof ProxiedPlayer)) {
            return;
        }
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)this, () -> this.main.getEventHandler().handleMessage(new BungeePlayer((ProxiedPlayer)pluginMessageEvent.getReceiver()), pluginMessageEvent.getData()));
    }

    @EventHandler
    public void onJoin(PostLoginEvent postLoginEvent) {
        this.main.getEventHandler().onPlayerJoin(new BungeePlayer(postLoginEvent.getPlayer()));
    }

    @EventHandler
    public void onServerSwitch(ServerSwitchEvent serverSwitchEvent) {
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)this, () -> this.main.getEventHandler().onPlayerJoinServer(new BungeePlayer(serverSwitchEvent.getPlayer())));
    }

    @EventHandler
    public void onLeave(PlayerDisconnectEvent playerDisconnectEvent) {
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)this, () -> this.main.getEventHandler().onPlayerLeave(new BungeePlayer(playerDisconnectEvent.getPlayer())));
    }

    @EventHandler
    public void onKick(ServerKickEvent serverKickEvent) {
        if (!serverKickEvent.getPlayer().isConnected()) {
            return;
        }
        if (serverKickEvent.getPlayer().getServer() == null) {
            return;
        }
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)this, () -> {
            Component component = BungeeComponentSerializer.get().deserialize(serverKickEvent.getKickReasonComponent());
            this.main.getEventHandler().onServerKick(new BungeePlayer(serverKickEvent.getPlayer()), new BungeeServer(serverKickEvent.getKickedFrom()), component, false);
        });
    }

    @Override
    public void unregisterCommand(String string) {
        BungeeCommand bungeeCommand = this.commandMap.get(string);
        if (bungeeCommand == null) {
            return;
        }
        this.getProxy().getPluginManager().unregisterCommand((Command)bungeeCommand);
        this.commandMap.remove(string);
    }

    @Override
    public void registerCommand(IBaseCommand iBaseCommand) {
        BungeeCommand bungeeCommand = new BungeeCommand((BaseCommand)iBaseCommand);
        this.commandMap.put(iBaseCommand.getName(), bungeeCommand);
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)bungeeCommand);
    }

    public QueueMain getMain() {
        return this.main;
    }
}

