/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.platforms.bungeecord.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import org.jetbrains.annotations.Nullable;
import us.ajg0702.queue.api.AjQueueAPI;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.api.server.AdaptedServerInfo;
import us.ajg0702.queue.api.server.AdaptedServerPing;
import us.ajg0702.queue.api.util.QueueLogger;
import us.ajg0702.queue.platforms.bungeecord.players.BungeePlayer;
import us.ajg0702.queue.platforms.bungeecord.server.BungeeServerInfo;
import us.ajg0702.queue.platforms.bungeecord.server.BungeeServerPing;

public class BungeeServer
implements AdaptedServer {
    private final ServerInfo handle;
    private final BungeeServerInfo serverInfo;
    private AdaptedServerPing lastPing = null;
    private AdaptedServerPing lastSuccessfullPing = null;
    private long lastOffline;
    private int offlineTime = 0;

    public BungeeServer(ServerInfo serverInfo) {
        this.handle = serverInfo;
        this.serverInfo = new BungeeServerInfo(serverInfo);
    }

    @Override
    public AdaptedServerInfo getServerInfo() {
        return this.serverInfo;
    }

    @Override
    public String getName() {
        return this.serverInfo.getName();
    }

    @Override
    public CompletableFuture<AdaptedServerPing> ping(boolean bl, QueueLogger queueLogger) {
        CompletableFuture<AdaptedServerPing> completableFuture = new CompletableFuture<AdaptedServerPing>();
        long l = System.currentTimeMillis();
        if (bl) {
            queueLogger.info("[pinger] [" + this.getName() + "] sending ping");
        }
        this.handle.ping((serverPing, throwable) -> {
            if (throwable != null || serverPing == null) {
                this.markOffline(bl, queueLogger, completableFuture, l, throwable);
                return;
            }
            this.offlineTime = 0;
            BungeeServerPing bungeeServerPing = new BungeeServerPing((ServerPing)serverPing, l);
            this.lastSuccessfullPing = bungeeServerPing;
            if (bl) {
                queueLogger.info("[pinger] [" + this.getName() + "] online. motd: " + bungeeServerPing.getPlainDescription() + "  players: " + bungeeServerPing.getPlayerCount() + "/" + bungeeServerPing.getMaxPlayers());
            }
            completableFuture.complete(bungeeServerPing);
            this.lastPing = bungeeServerPing;
        });
        return completableFuture;
    }

    private void markOffline(boolean bl, QueueLogger queueLogger, CompletableFuture<AdaptedServerPing> completableFuture, long l, @Nullable Throwable throwable) {
        long l2 = this.lastSuccessfullPing == null ? 0L : this.lastSuccessfullPing.getFetchedTime();
        this.offlineTime = (int)Math.min(l - l2, Integer.MAX_VALUE) / 1000;
        this.lastOffline = l;
        completableFuture.completeExceptionally(throwable);
        this.lastPing = null;
        if (bl) {
            queueLogger.info("[pinger] [" + this.getName() + "] offline:", throwable);
        }
    }

    @Override
    public Optional<AdaptedServerPing> getLastPing() {
        return Optional.ofNullable(this.lastPing);
    }

    @Override
    public boolean canAccess(AdaptedPlayer adaptedPlayer) {
        return this.handle.canAccess((CommandSender)((ProxiedPlayer)adaptedPlayer.getHandle()));
    }

    @Override
    public List<AdaptedPlayer> getPlayers() {
        ArrayList<AdaptedPlayer> arrayList = new ArrayList<AdaptedPlayer>();
        this.handle.getPlayers().forEach(proxiedPlayer -> arrayList.add(new BungeePlayer((ProxiedPlayer)proxiedPlayer)));
        return arrayList;
    }

    @Override
    public int getOfflineTime() {
        return this.offlineTime;
    }

    @Override
    public boolean canJoinFull(AdaptedPlayer adaptedPlayer) {
        if (adaptedPlayer == null) {
            return true;
        }
        return adaptedPlayer.hasPermission("ajqueue.joinfull") || adaptedPlayer.hasPermission("ajqueue.joinfullserver." + this.getName()) || adaptedPlayer.hasPermission("ajqueue.joinfullandbypassserver." + this.getName()) || adaptedPlayer.hasPermission("ajqueue.joinfullandbypass") || AjQueueAPI.getInstance().isPremium() && AjQueueAPI.getInstance().getLogic().getPermissionGetter().hasUniqueFullBypass(adaptedPlayer, this.getName());
    }

    @Override
    public boolean justWentOnline() {
        return (double)(System.currentTimeMillis() - this.lastOffline) <= AjQueueAPI.getInstance().getConfig().getDouble("wait-time") * 2.0 * 1000.0 && this.isOnline();
    }

    public ServerInfo getHandle() {
        return this.handle;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BungeeServer)) {
            return false;
        }
        BungeeServer bungeeServer = (BungeeServer)object;
        return this.getHandle().equals(bungeeServer.getHandle());
    }

    public int hashCode() {
        return Objects.hash(this.getHandle());
    }
}

