/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.spigot.placeholders.placeholders;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.regex.Matcher;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import us.ajg0702.queue.api.spigot.AjQueueSpigotAPI;
import us.ajg0702.queue.spigot.SpigotMain;
import us.ajg0702.queue.spigot.placeholders.Placeholder;

public class Status
extends Placeholder {
    private final String invalidMessage = "Invalid queue name";
    private final Map<String, String> cache = new ConcurrentHashMap<String, String>();

    public Status(SpigotMain spigotMain) {
        super(spigotMain);
    }

    @Override
    public String getRegex() {
        return "status_(.*)";
    }

    @Override
    public String parse(Matcher matcher, OfflinePlayer offlinePlayer) {
        String string = matcher.group(1);
        String string2 = this.cache.getOrDefault(string, "...");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                String string2 = AjQueueSpigotAPI.getInstance().getServerStatusString(string).get(30L, TimeUnit.SECONDS);
                this.cache.put(string, string2);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (TimeoutException timeoutException) {
                this.plugin.getLogger().log(Level.WARNING, "Timed out while trying to get placeholder data from proxy: ", timeoutException);
            }
            catch (ExecutionException executionException) {
                if (executionException.getCause() instanceof IllegalArgumentException) {
                    this.cache.put(string, "Invalid queue name");
                }
                throw new RuntimeException(executionException);
            }
        });
        return string2;
    }

    @Override
    public void cleanCache(Player player) {
    }
}

