/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.spigot.placeholders.placeholders;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.regex.Matcher;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import us.ajg0702.queue.api.spigot.AjQueueSpigotAPI;
import us.ajg0702.queue.spigot.SpigotMain;
import us.ajg0702.queue.spigot.placeholders.Placeholder;
import us.ajg0702.queue.spigot.utils.UUIDStringKey;

public class StatusPlayer
extends Placeholder {
    private final Map<UUIDStringKey, String> cache = new ConcurrentHashMap<UUIDStringKey, String>();

    public StatusPlayer(SpigotMain spigotMain) {
        super(spigotMain);
    }

    @Override
    public String getRegex() {
        return "status_(.*)_player";
    }

    @Override
    public String parse(Matcher matcher, OfflinePlayer offlinePlayer) {
        String string = matcher.group(1);
        UUIDStringKey uUIDStringKey = new UUIDStringKey(offlinePlayer.getUniqueId(), string);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                String string2 = AjQueueSpigotAPI.getInstance().getServerStatusString(string, offlinePlayer.getUniqueId()).get(30L, TimeUnit.SECONDS);
                this.cache.put(uUIDStringKey, string2);
            }
            catch (InterruptedException | ExecutionException exception) {
                throw new RuntimeException(exception);
            }
            catch (TimeoutException timeoutException) {
                this.plugin.getLogger().log(Level.WARNING, "Timed out while trying to get placeholder data from proxy: ", timeoutException);
            }
        });
        return this.cache.getOrDefault(uUIDStringKey, "...");
    }

    @Override
    public void cleanCache(Player player) {
        this.cache.entrySet().removeIf(entry -> ((UUIDStringKey)entry.getKey()).getUuid().equals(player.getUniqueId()));
    }
}

