/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.commands.subcommands;

import me.mrgeneralq.bloodmoon.enums.DataModification;
import me.mrgeneralq.bloodmoon.interfaces.ISubCommand;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonScheduleService;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.statics.Message;
import me.mrgeneralq.bloodmoon.utils.CommandUtils;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class CancelSubCommand
implements ISubCommand {
    private final IBloodmoonService bloodmoonService;
    private final IMessageService messageService;
    private final IBloodmoonScheduleService scheduleService;

    public CancelSubCommand(IBloodmoonService iBloodmoonService, IMessageService iMessageService, IBloodmoonScheduleService iBloodmoonScheduleService) {
        this.bloodmoonService = iBloodmoonService;
        this.messageService = iMessageService;
        this.scheduleService = iBloodmoonScheduleService;
    }

    @Override
    public boolean executeCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        World world = CommandUtils.getWorldFromCommand(commandSender, stringArray, 0);
        if (world == null) {
            commandSender.sendMessage(this.messageService.getMessage(Message.specifyWorldWhenUsingConsole, true));
            return true;
        }
        if (!this.scheduleService.isScheduled(world)) {
            commandSender.sendMessage(this.messageService.getMessage(Message.notScheduled, true));
            return true;
        }
        if (this.bloodmoonService.bloodmoonIsRunning(world)) {
            commandSender.sendMessage(this.messageService.getMessage(Message.bloodmoonAlreadyRunning, true));
            return true;
        }
        if (this.bloodmoonService.isNight(world)) {
            commandSender.sendMessage(this.messageService.getMessage(Message.cancelNight, true));
            return true;
        }
        this.scheduleService.removeSchedule(world, DataModification.MEMORY);
        commandSender.sendMessage(this.messageService.getMessageHelper(Message.canceled).useConfigMessage().usePrefix().setWorld(world.getName()).getMessage());
        return true;
    }
}

