/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.commands.subcommands;

import me.mrgeneralq.bloodmoon.factories.PlayerDeathActionFactory;
import me.mrgeneralq.bloodmoon.interfaces.ISubCommand;
import me.mrgeneralq.bloodmoon.interfaces.services.IActionService;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonScheduleService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IItemService;
import me.mrgeneralq.bloodmoon.interfaces.services.ILifeCycleService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMobService;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class ReloadSubCommand
implements ISubCommand {
    private final IConfigService configService;
    private final IMobService mobService;
    private final IItemService itemService;
    private final IActionService actionService;
    private final ILifeCycleService lifeCycleService;
    private final IMessageService messageService;
    private final IBloodmoonScheduleService scheduleService;

    public ReloadSubCommand(IConfigService iConfigService, IMobService iMobService, IItemService iItemService, IActionService iActionService, ILifeCycleService iLifeCycleService, IMessageService iMessageService, IBloodmoonScheduleService iBloodmoonScheduleService) {
        this.configService = iConfigService;
        this.mobService = iMobService;
        this.itemService = iItemService;
        this.actionService = iActionService;
        this.lifeCycleService = iLifeCycleService;
        this.messageService = iMessageService;
        this.scheduleService = iBloodmoonScheduleService;
    }

    @Override
    public boolean executeCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        this.configService.reloadConfig();
        this.mobService.reloadConfig();
        this.itemService.reloadConfig();
        this.actionService.reloadConfig();
        this.lifeCycleService.reloadConfig();
        this.messageService.reloadConfig();
        this.scheduleService.reloadConfig();
        PlayerDeathActionFactory.getFactory().build(this.configService, this.messageService);
        commandSender.sendMessage(this.messageService.getMessage(Message.configReloaded, true));
        return true;
    }
}

