/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.commands.subcommands.schedule;

import me.mrgeneralq.bloodmoon.interfaces.ISubCommand;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonScheduleService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.models.BloodmoonSchedule;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ScheduleInfoCommand
implements ISubCommand {
    private IBloodmoonScheduleService bloodmoonScheduleService;
    private IMessageService messageService;
    private IConfigService configService;

    public ScheduleInfoCommand(IBloodmoonScheduleService iBloodmoonScheduleService, IMessageService iMessageService, IConfigService iConfigService) {
        this.bloodmoonScheduleService = iBloodmoonScheduleService;
        this.messageService = iMessageService;
        this.configService = iConfigService;
    }

    @Override
    public boolean executeCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        Player player = (Player)commandSender;
        World world = player.getWorld();
        if (stringArray.length > 0) {
            if (Bukkit.getWorld((String)stringArray[0]) == null) {
                player.sendMessage(this.messageService.getMessage(Message.invalidWorld, true));
                return true;
            }
            world = Bukkit.getWorld((String)stringArray[0]);
        }
        if (!this.bloodmoonScheduleService.scheduleExists(world)) {
            player.sendMessage(this.messageService.getMessage(Message.typeNotExists, true).replaceAll("%type%", "Schedule"));
            return true;
        }
        BloodmoonSchedule bloodmoonSchedule = this.bloodmoonScheduleService.getScheduleFromRepo(world);
        player.sendMessage(this.messageService.getRawMessage("&f=======================", false));
        player.sendMessage(this.messageService.getRawMessage(String.format("&dSCHEDULE INFO: &a%s", world.getName()), false));
        player.sendMessage(this.messageService.getRawMessage("&f=======================", false));
        player.sendMessage(this.messageService.getRawMessage(String.format("&c%s&f: &e%b", "broadcast", bloodmoonSchedule.isBroadcasting()), false));
        player.sendMessage(this.messageService.getRawMessage(String.format("&c%s&f: &e%.2f", "chance", bloodmoonSchedule.getChance()), false));
        player.sendMessage(this.messageService.getRawMessage(String.format("&c%s&f: &e%b", "random-days", bloodmoonSchedule.isRandomDays()), false));
        player.sendMessage(this.messageService.getRawMessage(String.format("&c%s&f: &e%b", "repeating", bloodmoonSchedule.isRepeating()), false));
        player.sendMessage(this.messageService.getRawMessage(String.format("&c%s&f: &e%d", "days", bloodmoonSchedule.getTotalDays()), false));
        player.sendMessage(this.messageService.getRawMessage(String.format("&c%s&f: &e%s", "days-left-msg", bloodmoonSchedule.getDaysLeftMessage()), false));
        player.sendMessage(this.messageService.getRawMessage(String.format("&c%s&f: &e%s", "tonight-msg", bloodmoonSchedule.getTonightMessage()), false));
        return true;
    }
}

